/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usergroups;

import java.util.Objects;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.GroupDto;

public class DefaultGroupFinder {
    private final DbClient dbClient;

    public DefaultGroupFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public GroupDto findDefaultGroup(DbSession dbSession, String organizationUuid) {
        int defaultGroupId = (Integer)this.dbClient.organizationDao().getDefaultGroupId(dbSession, organizationUuid).orElseThrow(() -> new IllegalStateException(String.format("Default group cannot be found on organization '%s'", organizationUuid)));
        return Objects.requireNonNull(this.dbClient.groupDao().selectById(dbSession, defaultGroupId), String.format("Group '%s' cannot be found", defaultGroupId));
    }
}

