/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.ws.HomepageTypes;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Users;

public class CurrentAction
implements UsersWsAction {
    private static final String GOVERNANCE_PLUGIN_KEY = "governance";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final AvatarResolver avatarResolver;
    private final HomepageTypes homepageTypes;
    private final PluginRepository pluginRepository;

    public CurrentAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, AvatarResolver avatarResolver, HomepageTypes homepageTypes, PluginRepository pluginRepository) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.avatarResolver = avatarResolver;
        this.homepageTypes = homepageTypes;
        this.pluginRepository = pluginRepository;
    }

    public void define(WebService.NewController context) {
        context.createAction("current").setDescription("Get the details of the current authenticated user.").setSince("5.2").setInternal(true).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("current-example.json")).setChangelog(new Change[]{new Change("6.5", "showOnboardingTutorial is now returned in the response"), new Change("7.1", "'parameter' is replaced by 'component' and 'organization' in the response")});
    }

    public void handle(Request request, Response response) throws Exception {
        if (this.userSession.isLoggedIn()) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                WsUtils.writeProtobuf((Message)this.toWsResponse(dbSession, this.userSession.getLogin()), request, response);
            }
        } else {
            WsUtils.writeProtobuf((Message)Users.CurrentWsResponse.newBuilder().setIsLoggedIn(false).setPermissions(Users.CurrentWsResponse.Permissions.newBuilder().addAllGlobal(this.getGlobalPermissions()).build()).build(), request, response);
        }
    }

    private Users.CurrentWsResponse toWsResponse(DbSession dbSession, String userLogin) {
        UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, userLogin);
        Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User login '%s' cannot be found", (Object[])new Object[]{userLogin});
        Collection groups = this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, Collections.singletonList(userLogin)).get((Object)userLogin);
        Users.CurrentWsResponse.Builder builder = Users.CurrentWsResponse.newBuilder().setIsLoggedIn(true).setLogin(user.getLogin()).setName(user.getName()).setLocal(user.isLocal()).addAllGroups((Iterable)groups).addAllScmAccounts((Iterable)user.getScmAccountsAsList()).setPermissions(Users.CurrentWsResponse.Permissions.newBuilder().addAllGlobal(this.getGlobalPermissions()).build()).setHomepage(this.buildHomepage(dbSession, user)).setShowOnboardingTutorial(!user.isOnboarded());
        Protobuf.setNullable((Object)Strings.emptyToNull((String)user.getEmail()), arg_0 -> ((Users.CurrentWsResponse.Builder)builder).setEmail(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)user.getEmail()), u -> builder.setAvatar(this.avatarResolver.create(user)));
        Protobuf.setNullable((Object)user.getExternalLogin(), arg_0 -> ((Users.CurrentWsResponse.Builder)builder).setExternalIdentity(arg_0));
        Protobuf.setNullable((Object)user.getExternalIdentityProvider(), arg_0 -> ((Users.CurrentWsResponse.Builder)builder).setExternalProvider(arg_0));
        return builder.build();
    }

    private List<String> getGlobalPermissions() {
        String defaultOrganizationUuid = this.defaultOrganizationProvider.get().getUuid();
        return OrganizationPermission.all().filter(permission -> this.userSession.hasPermission((OrganizationPermission)permission, defaultOrganizationUuid)).map(OrganizationPermission::getKey).collect(Collectors.toList());
    }

    private Users.CurrentWsResponse.Homepage buildHomepage(DbSession dbSession, UserDto user) {
        if (CurrentAction.noHomepageSet(user)) {
            return this.defaultHomepage();
        }
        return this.doBuildHomepage(dbSession, user).orElse(this.defaultHomepage());
    }

    private Optional<Users.CurrentWsResponse.Homepage> doBuildHomepage(DbSession dbSession, UserDto user) {
        if (Users.CurrentWsResponse.HomepageType.PROJECT.toString().equals(user.getHomepageType())) {
            return this.projectHomepage(dbSession, user);
        }
        if (Users.CurrentWsResponse.HomepageType.APPLICATION.toString().equals(user.getHomepageType()) || Users.CurrentWsResponse.HomepageType.PORTFOLIO.toString().equals(user.getHomepageType())) {
            return this.applicationAndPortfolioHomepage(dbSession, user);
        }
        if (Users.CurrentWsResponse.HomepageType.ORGANIZATION.toString().equals(user.getHomepageType())) {
            return this.organizationHomepage(dbSession, user);
        }
        return Optional.of(Users.CurrentWsResponse.Homepage.newBuilder().setType(Users.CurrentWsResponse.HomepageType.valueOf((String)user.getHomepageType())).build());
    }

    private Optional<Users.CurrentWsResponse.Homepage> projectHomepage(DbSession dbSession, UserDto user) {
        Optional<Object> projectOptional = Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, Optional.of(user.getHomepageParameter()).orElse("")).orNull());
        if (this.shouldCleanProjectHomepage(projectOptional)) {
            this.cleanUserHomepageInDb(dbSession, user);
            return Optional.empty();
        }
        Users.CurrentWsResponse.Homepage.Builder homepage = Users.CurrentWsResponse.Homepage.newBuilder().setType(Users.CurrentWsResponse.HomepageType.valueOf((String)user.getHomepageType())).setComponent(((ComponentDto)projectOptional.get()).getKey());
        Protobuf.setNullable((Object)((ComponentDto)projectOptional.get()).getBranch(), arg_0 -> ((Users.CurrentWsResponse.Homepage.Builder)homepage).setBranch(arg_0));
        return Optional.of(homepage.build());
    }

    private boolean shouldCleanProjectHomepage(Optional<ComponentDto> projectOptional) {
        return !projectOptional.isPresent() || !this.userSession.hasComponentPermission("user", projectOptional.get());
    }

    private Optional<Users.CurrentWsResponse.Homepage> applicationAndPortfolioHomepage(DbSession dbSession, UserDto user) {
        Optional<Object> componentOptional = Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, Optional.of(user.getHomepageParameter()).orElse("")).orNull());
        if (this.shouldCleanApplicationOrPortfolioHomepage(componentOptional)) {
            this.cleanUserHomepageInDb(dbSession, user);
            return Optional.empty();
        }
        return Optional.of(Users.CurrentWsResponse.Homepage.newBuilder().setType(Users.CurrentWsResponse.HomepageType.valueOf((String)user.getHomepageType())).setComponent(((ComponentDto)componentOptional.get()).getKey()).build());
    }

    private boolean shouldCleanApplicationOrPortfolioHomepage(Optional<ComponentDto> componentOptional) {
        return !componentOptional.isPresent() || !this.pluginRepository.hasPlugin(GOVERNANCE_PLUGIN_KEY) || !this.userSession.hasComponentPermission("user", componentOptional.get());
    }

    private Optional<Users.CurrentWsResponse.Homepage> organizationHomepage(DbSession dbSession, UserDto user) {
        Optional organizationOptional = this.dbClient.organizationDao().selectByUuid(dbSession, Optional.of(user.getHomepageParameter()).orElse(""));
        if (!organizationOptional.isPresent()) {
            this.cleanUserHomepageInDb(dbSession, user);
            return Optional.empty();
        }
        return Optional.of(Users.CurrentWsResponse.Homepage.newBuilder().setType(Users.CurrentWsResponse.HomepageType.valueOf((String)user.getHomepageType())).setOrganization(((OrganizationDto)organizationOptional.get()).getKey()).build());
    }

    private void cleanUserHomepageInDb(DbSession dbSession, UserDto user) {
        this.dbClient.userDao().cleanHomepage(dbSession, user);
    }

    private Users.CurrentWsResponse.Homepage defaultHomepage() {
        return Users.CurrentWsResponse.Homepage.newBuilder().setType(Users.CurrentWsResponse.HomepageType.valueOf((String)this.homepageTypes.getDefaultType().name())).build();
    }

    private static boolean noHomepageSet(UserDto user) {
        return user.getHomepageType() == null;
    }
}

