/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.ws;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.test.index.CoveredFileDoc;
import org.sonar.server.test.index.TestDoc;
import org.sonar.server.test.index.TestIndex;
import org.sonar.server.test.ws.TestsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Tests;

public class CoveredFilesAction
implements TestsWsAction {
    public static final String TEST_ID = "testId";
    private final DbClient dbClient;
    private final TestIndex index;
    private final UserSession userSession;

    public CoveredFilesAction(DbClient dbClient, TestIndex index, UserSession userSession) {
        this.dbClient = dbClient;
        this.index = index;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("covered_files").setDescription("Get the list of source files covered by a test. Require Browse permission on test file's project").setSince("4.4").setResponseExample(Resources.getResource(this.getClass(), (String)"tests-example-covered-files.json")).setDeprecatedSince("5.6").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.6", "\"branch\" field is now returned")}).addPagingParams(100);
        action.createParam(TEST_ID).setRequired(true).setDescription("Test ID").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
    }

    public void handle(Request request, Response response) throws Exception {
        String testId = request.mandatoryParam(TEST_ID);
        TestDoc testDoc = WsUtils.checkFoundWithOptional(this.index.getNullableByTestUuid(testId), "Test with id '%s' is not found", testId);
        this.userSession.checkComponentUuidPermission("codeviewer", testDoc.fileUuid());
        List<CoveredFileDoc> coveredFiles = this.index.coveredFiles(testId);
        Map<String, ComponentDto> componentsByUuid = this.buildComponentsByUuid(coveredFiles);
        Tests.CoveredFilesResponse.Builder responseBuilder = Tests.CoveredFilesResponse.newBuilder();
        if (!coveredFiles.isEmpty()) {
            for (CoveredFileDoc doc : coveredFiles) {
                Tests.CoveredFilesResponse.CoveredFile.Builder fileBuilder = Tests.CoveredFilesResponse.CoveredFile.newBuilder();
                fileBuilder.setId(doc.fileUuid());
                fileBuilder.setCoveredLines(doc.coveredLines().size());
                ComponentDto component = componentsByUuid.get(doc.fileUuid());
                if (component != null) {
                    fileBuilder.setKey(component.getKey());
                    fileBuilder.setLongName(component.longName());
                    Protobuf.setNullable((Object)component.getBranch(), arg_0 -> ((Tests.CoveredFilesResponse.CoveredFile.Builder)fileBuilder).setBranch(arg_0));
                }
                responseBuilder.addFiles(fileBuilder);
            }
        }
        WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
    }

    private Map<String, ComponentDto> buildComponentsByUuid(List<CoveredFileDoc> coveredFiles) {
        List components;
        List sourceFileUuids = Lists.transform(coveredFiles, (Function)new CoveredFileToFileUuidFunction());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            components = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)sourceFileUuids);
        }
        return Maps.uniqueIndex((Iterable)components, ComponentDto::uuid);
    }

    private static class CoveredFileToFileUuidFunction
    implements Function<CoveredFileDoc, String> {
        private CoveredFileToFileUuidFunction() {
        }

        public String apply(@Nonnull CoveredFileDoc coveredFile) {
            return coveredFile.fileUuid();
        }
    }
}

