/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.process.ProcessProperties;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.setting.ws.Setting;
import org.sonar.server.setting.ws.SettingsWs;
import org.sonar.server.user.UserSession;

@ServerSide
public class SettingsWsSupport {
    private static final Collector<CharSequence, ?, String> COMMA_JOINER = Collectors.joining(",");
    public static final String DOT_SECURED = ".secured";
    public static final String DOT_LICENSE = ".license";
    private static final String LICENSE_SUFFIX = ".license.secured";
    private static final String LICENSE_HASH_SUFFIX = ".licenseHash.secured";
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final UserSession userSession;

    public SettingsWsSupport(DefaultOrganizationProvider defaultOrganizationProvider, UserSession userSession) {
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.userSession = userSession;
    }

    static void validateKey(String key) {
        Arrays.stream(ProcessProperties.Property.values()).filter(property -> property.getKey().equalsIgnoreCase(key)).findFirst().ifPresent(property -> {
            throw new IllegalArgumentException(String.format("Setting '%s' can only be used in sonar.properties", key));
        });
    }

    Predicate<Setting> isSettingVisible(Optional<ComponentDto> component) {
        return setting -> this.isVisible(setting.getKey(), setting.getDefinition(), component);
    }

    Predicate<PropertyDefinition> isDefinitionVisible(Optional<ComponentDto> component) {
        return propertyDefinition -> this.isVisible(propertyDefinition.key(), (PropertyDefinition)propertyDefinition, component);
    }

    boolean isVisible(String key, @Nullable PropertyDefinition definition, Optional<ComponentDto> component) {
        return this.hasPermission(OrganizationPermission.SCAN, "scan", component) || this.verifySecuredSetting(key, definition, component) && this.verifyLicenseSetting(key, definition);
    }

    private boolean verifySecuredSetting(String key, @Nullable PropertyDefinition definition, Optional<ComponentDto> component) {
        return SettingsWsSupport.isLicense(key, definition) || !key.endsWith(DOT_SECURED) || this.hasPermission(OrganizationPermission.ADMINISTER, "admin", component);
    }

    private boolean verifyLicenseSetting(String key, @Nullable PropertyDefinition definition) {
        return !SettingsWsSupport.isLicense(key, definition) || this.userSession.isLoggedIn();
    }

    private static boolean isLicense(String key, @Nullable PropertyDefinition definition) {
        return key.endsWith(LICENSE_SUFFIX) || key.endsWith(LICENSE_HASH_SUFFIX) || definition != null && definition.type() == PropertyType.LICENSE;
    }

    private boolean hasPermission(OrganizationPermission orgPermission, String projectPermission, Optional<ComponentDto> component) {
        if (this.userSession.hasPermission(orgPermission, this.defaultOrganizationProvider.get().getUuid())) {
            return true;
        }
        return component.map(c -> this.userSession.hasComponentPermission(projectPermission, (ComponentDto)c)).orElse(false);
    }

    WebService.NewParam addBranchParam(WebService.NewAction action) {
        return action.createParam("branch").setDescription("Branch key. Only available on following settings : %s", new Object[]{SettingsWs.SETTING_ON_BRANCHES.stream().collect(COMMA_JOINER)}).setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
    }

    WebService.NewParam addPullRequestParam(WebService.NewAction action) {
        return action.createParam("pullRequest").setDescription("Pull request. Only available on following settings : %s", new Object[]{SettingsWs.SETTING_ON_BRANCHES.stream().collect(COMMA_JOINER)}).setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
    }
}

