/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.server.ServerSide;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleWsSupport {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public RuleWsSupport(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void checkQProfileAdminPermissionOnDefaultOrganization() {
        this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, this.defaultOrganizationProvider.get().getUuid());
    }

    public OrganizationDto getOrganizationByKey(DbSession dbSession, @Nullable String organizationKey) {
        String organizationOrDefaultKey = Optional.ofNullable(organizationKey).orElseGet(this.defaultOrganizationProvider.get()::getKey);
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationOrDefaultKey), "No organization with key '%s'", organizationOrDefaultKey);
    }

    Map<String, UserDto> getUsersByUuid(DbSession dbSession, List<RuleDto> rules) {
        Set userUuids = (Set)rules.stream().map(RuleDto::getNoteUserUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.userDao().selectByUuids(dbSession, (Collection)userUuids).stream().collect(MoreCollectors.uniqueIndex(UserDto::getUuid));
    }
}

