/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.rule.DeprecatedRuleKeyDto;

@Immutable
class SingleDeprecatedRuleKey {
    private String oldRuleKey;
    private String oldRepositoryKey;
    private String newRuleKey;
    private String newRepositoryKey;
    private String uuid;
    private Integer ruleId;

    private SingleDeprecatedRuleKey() {
    }

    public static Set<SingleDeprecatedRuleKey> from(RulesDefinition.Rule rule) {
        return (Set)rule.deprecatedRuleKeys().stream().map(r -> new SingleDeprecatedRuleKey().setNewRepositoryKey(rule.repository().key()).setNewRuleKey(rule.key()).setOldRepositoryKey(r.repository()).setOldRuleKey(r.rule())).collect(MoreCollectors.toSet((int)rule.deprecatedRuleKeys().size()));
    }

    public static SingleDeprecatedRuleKey from(DeprecatedRuleKeyDto rule) {
        return new SingleDeprecatedRuleKey().setUuid(rule.getUuid()).setRuleId(rule.getRuleId()).setNewRepositoryKey(rule.getNewRepositoryKey()).setNewRuleKey(rule.getNewRuleKey()).setOldRepositoryKey(rule.getOldRepositoryKey()).setOldRuleKey(rule.getOldRuleKey());
    }

    public String getOldRuleKey() {
        return this.oldRuleKey;
    }

    public String getOldRepositoryKey() {
        return this.oldRepositoryKey;
    }

    public RuleKey getOldRuleKeyAsRuleKey() {
        return RuleKey.of((String)this.oldRepositoryKey, (String)this.oldRuleKey);
    }

    public RuleKey getNewRuleKeyAsRuleKey() {
        return RuleKey.of((String)this.newRepositoryKey, (String)this.newRuleKey);
    }

    @CheckForNull
    public String getNewRuleKey() {
        return this.newRuleKey;
    }

    @CheckForNull
    public String getNewRepositoryKey() {
        return this.newRepositoryKey;
    }

    @CheckForNull
    public String getUuid() {
        return this.uuid;
    }

    @CheckForNull
    public Integer getRuleId() {
        return this.ruleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleDeprecatedRuleKey)) {
            return false;
        }
        SingleDeprecatedRuleKey that = (SingleDeprecatedRuleKey)o;
        return Objects.equals(this.oldRuleKey, that.oldRuleKey) && Objects.equals(this.oldRepositoryKey, that.oldRepositoryKey) && Objects.equals(this.newRuleKey, that.newRuleKey) && Objects.equals(this.newRepositoryKey, that.newRepositoryKey);
    }

    public int hashCode() {
        return Objects.hash(this.oldRuleKey, this.oldRepositoryKey, this.newRuleKey, this.newRepositoryKey);
    }

    private SingleDeprecatedRuleKey setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    private SingleDeprecatedRuleKey setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    private SingleDeprecatedRuleKey setOldRuleKey(String oldRuleKey) {
        this.oldRuleKey = oldRuleKey;
        return this;
    }

    private SingleDeprecatedRuleKey setOldRepositoryKey(String oldRepositoryKey) {
        this.oldRepositoryKey = oldRepositoryKey;
        return this;
    }

    private SingleDeprecatedRuleKey setNewRuleKey(@Nullable String newRuleKey) {
        this.newRuleKey = newRuleKey;
        return this;
    }

    private SingleDeprecatedRuleKey setNewRepositoryKey(@Nullable String newRepositoryKey) {
        this.newRepositoryKey = newRepositoryKey;
        return this;
    }
}

