/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule;

import org.sonar.api.rule.RuleStatus;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDao;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.computation.task.projectanalysis.issue.NewExternalRule;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleImpl;
import org.sonar.server.rule.index.RuleIndexer;

public class ExternalRuleCreator {
    private final DbClient dbClient;
    private final System2 system2;
    private final RuleIndexer ruleIndexer;

    public ExternalRuleCreator(DbClient dbClient, System2 system2, RuleIndexer ruleIndexer) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.ruleIndexer = ruleIndexer;
    }

    public Rule persistAndIndex(DbSession dbSession, NewExternalRule external) {
        RuleDao dao = this.dbClient.ruleDao();
        dao.insert(dbSession, new RuleDefinitionDto().setRuleKey(external.getKey()).setPluginKey(external.getPluginKey()).setIsExternal(external.isExternal()).setName(external.getName()).setScope(RuleDto.Scope.ALL).setStatus(RuleStatus.READY).setCreatedAt(this.system2.now()).setUpdatedAt(this.system2.now()));
        RuleImpl newRule = new RuleImpl(dao.selectOrFailByKey(dbSession, external.getKey()));
        this.ruleIndexer.commitAndIndex(dbSession, newRule.getId());
        return newRule;
    }
}

