/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.SearchUsersQuery;
import org.sonar.db.qualityprofile.UserMembershipDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.qualityprofile.ws.SearchUsersRequest;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Qualityprofiles;

public class SearchUsersAction
implements QProfileWsAction {
    private static final Map<WebService.SelectionMode, String> MEMBERSHIP = ImmutableMap.of((Object)WebService.SelectionMode.SELECTED, (Object)"IN", (Object)WebService.SelectionMode.DESELECTED, (Object)"OUT", (Object)WebService.SelectionMode.ALL, (Object)"ANY");
    private final DbClient dbClient;
    private final QProfileWsSupport wsSupport;
    private final Languages languages;
    private final AvatarResolver avatarResolver;

    public SearchUsersAction(DbClient dbClient, QProfileWsSupport wsSupport, Languages languages, AvatarResolver avatarResolver) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.languages = languages;
        this.avatarResolver = avatarResolver;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_users").setDescription("List the users that are allowed to edit a Quality Profile.<br>Requires one of the following permissions:<ul>  <li>'Administer Quality Profiles'</li>  <li>Edit right on the specified quality profile</li></ul>").setHandler((RequestHandler)this).setInternal(true).addSearchQuery("freddy", new String[]{"names", "logins"}).addSelectionModeParam().addPagingParams(25).setResponseExample(this.getClass().getResource("search_users-example.json")).setSince("6.6");
        action.createParam("qualityProfile").setDescription("Quality Profile name").setRequired(true).setExampleValue((Object)"Recommended quality profile");
        action.createParam("language").setDescription("Quality profile language").setRequired(true).setPossibleValues((Collection)Arrays.stream(this.languages.all()).map(Language::getKey).collect(MoreCollectors.toSet()));
        QProfileWsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        SearchUsersRequest wsRequest = SearchUsersAction.buildRequest(request);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, wsRequest.getOrganization());
            QProfileDto profile = this.wsSupport.getProfile(dbSession, organization, wsRequest.getQualityProfile(), wsRequest.getLanguage());
            this.wsSupport.checkCanEdit(dbSession, organization, profile);
            SearchUsersQuery query = SearchUsersQuery.builder().setOrganization(organization).setProfile(profile).setQuery(wsRequest.getQuery()).setMembership(MEMBERSHIP.get(WebService.SelectionMode.fromParam((String)wsRequest.getSelected()))).build();
            int total = this.dbClient.qProfileEditUsersDao().countByQuery(dbSession, query);
            List usersMembership = this.dbClient.qProfileEditUsersDao().selectByQuery(dbSession, query, Pagination.forPage((int)wsRequest.getPage()).andSize(wsRequest.getPageSize().intValue()));
            Map usersById = (Map)this.dbClient.userDao().selectByIds(dbSession, (Collection)usersMembership.stream().map(UserMembershipDto::getUserId).collect(MoreCollectors.toList())).stream().collect(MoreCollectors.uniqueIndex(UserDto::getId));
            WsUtils.writeProtobuf((Message)Qualityprofiles.SearchUsersResponse.newBuilder().addAllUsers((Iterable)usersMembership.stream().map(userMembershipDto -> this.toUser((UserDto)usersById.get(userMembershipDto.getUserId()), userMembershipDto.isSelected())).collect(MoreCollectors.toList())).setPaging(SearchUsersAction.buildPaging(wsRequest, total)).build(), request, response);
        }
    }

    private static SearchUsersRequest buildRequest(Request request) {
        return SearchUsersRequest.builder().setOrganization(request.param("organization")).setQualityProfile(request.mandatoryParam("qualityProfile")).setLanguage(request.mandatoryParam("language")).setQuery(request.param("q")).setSelected(request.mandatoryParam("selected")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).build();
    }

    private Qualityprofiles.SearchUsersResponse.User toUser(UserDto user, boolean isSelected) {
        Qualityprofiles.SearchUsersResponse.User.Builder builder = Qualityprofiles.SearchUsersResponse.User.newBuilder().setLogin(user.getLogin()).setName(user.getName()).setSelected(isSelected);
        Protobuf.setNullable((Object)Strings.emptyToNull((String)user.getEmail()), e -> builder.setAvatar(this.avatarResolver.create(user)));
        return builder.build();
    }

    private static Common.Paging buildPaging(SearchUsersRequest wsRequest, int total) {
        return Common.Paging.newBuilder().setPageIndex(wsRequest.getPage().intValue()).setPageSize(wsRequest.getPageSize().intValue()).setTotal(total).build();
    }
}

