/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BulkChangeResult;
import org.sonar.server.qualityprofile.QProfileRules;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivationContext;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.rule.index.RuleQuery;

public class QProfileRulesImpl
implements QProfileRules {
    private final DbClient db;
    private final RuleActivator ruleActivator;
    private final RuleIndex ruleIndex;
    private final ActiveRuleIndexer activeRuleIndexer;

    public QProfileRulesImpl(DbClient db, RuleActivator ruleActivator, RuleIndex ruleIndex, ActiveRuleIndexer activeRuleIndexer) {
        this.db = db;
        this.ruleActivator = ruleActivator;
        this.ruleIndex = ruleIndex;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    @Override
    public List<ActiveRuleChange> activateAndCommit(DbSession dbSession, QProfileDto profile, Collection<RuleActivation> activations) {
        QProfileRulesImpl.verifyNotBuiltIn(profile);
        Set ruleIds = (Set)activations.stream().map(RuleActivation::getRuleId).collect(MoreCollectors.toHashSet((int)activations.size()));
        RuleActivationContext context = this.ruleActivator.createContextForUserProfile(dbSession, profile, ruleIds);
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        for (RuleActivation activation : activations) {
            changes.addAll(this.ruleActivator.activate(dbSession, activation, context));
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    @Override
    public BulkChangeResult bulkActivateAndCommit(DbSession dbSession, QProfileDto profile, RuleQuery ruleQuery, @Nullable String severity) {
        QProfileRulesImpl.verifyNotBuiltIn(profile);
        return this.doBulk(dbSession, profile, ruleQuery, (context, ruleDefinition) -> {
            RuleActivation activation = RuleActivation.create(ruleDefinition.getId(), severity, null);
            return this.ruleActivator.activate(dbSession, activation, (RuleActivationContext)context);
        });
    }

    @Override
    public List<ActiveRuleChange> deactivateAndCommit(DbSession dbSession, QProfileDto profile, Collection<Integer> ruleIds) {
        QProfileRulesImpl.verifyNotBuiltIn(profile);
        RuleActivationContext context = this.ruleActivator.createContextForUserProfile(dbSession, profile, ruleIds);
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        for (Integer ruleId : ruleIds) {
            changes.addAll(this.ruleActivator.deactivate(dbSession, context, ruleId, false));
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    @Override
    public BulkChangeResult bulkDeactivateAndCommit(DbSession dbSession, QProfileDto profile, RuleQuery ruleQuery) {
        QProfileRulesImpl.verifyNotBuiltIn(profile);
        return this.doBulk(dbSession, profile, ruleQuery, (context, ruleDefinition) -> this.ruleActivator.deactivate(dbSession, (RuleActivationContext)context, ruleDefinition.getId(), false));
    }

    @Override
    public List<ActiveRuleChange> deleteRule(DbSession dbSession, RuleDefinitionDto rule) {
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        ArrayList activeRuleIds = new ArrayList();
        this.db.activeRuleDao().selectByRuleIdOfAllOrganizations(dbSession, rule.getId().intValue()).forEach(ar -> {
            activeRuleIds.add(ar.getId());
            changes.add(new ActiveRuleChange(ActiveRuleChange.Type.DEACTIVATED, (ActiveRuleDto)ar, rule));
        });
        this.db.activeRuleDao().deleteByIds(dbSession, activeRuleIds);
        this.db.activeRuleDao().deleteParamsByActiveRuleIds(dbSession, activeRuleIds);
        return changes;
    }

    private static void verifyNotBuiltIn(QProfileDto profile) {
        Preconditions.checkArgument((!profile.isBuiltIn() ? 1 : 0) != 0, (String)"The built-in profile %s is read-only and can't be updated", (Object[])new Object[]{profile.getName()});
    }

    private BulkChangeResult doBulk(DbSession dbSession, QProfileDto profile, RuleQuery ruleQuery, BiFunction<RuleActivationContext, RuleDefinitionDto, List<ActiveRuleChange>> fn) {
        BulkChangeResult result = new BulkChangeResult();
        HashSet ruleIds = Sets.newHashSet(this.ruleIndex.searchAll(ruleQuery));
        RuleActivationContext context = this.ruleActivator.createContextForUserProfile(dbSession, profile, ruleIds);
        for (Integer ruleId : ruleIds) {
            try {
                context.reset(ruleId);
                RuleDefinitionDto ruleDefinition = context.getRule().get();
                List<ActiveRuleChange> changes = fn.apply(context, ruleDefinition);
                result.addChanges(changes);
                if (changes.isEmpty()) continue;
                result.incrementSucceeded();
            }
            catch (BadRequestException e) {
                result.incrementFailed();
                result.getErrors().addAll(e.errors());
            }
        }
        this.activeRuleIndexer.commitAndIndex(dbSession, result.getChanges());
        return result;
    }
}

