/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileUpdate;
import org.sonar.server.qualityprofile.RuleActivation;
import org.sonar.server.qualityprofile.RuleActivationContext;
import org.sonar.server.qualityprofile.RuleActivator;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;

public class BuiltInQProfileUpdateImpl
implements BuiltInQProfileUpdate {
    private final DbClient dbClient;
    private final RuleActivator ruleActivator;
    private final ActiveRuleIndexer activeRuleIndexer;

    public BuiltInQProfileUpdateImpl(DbClient dbClient, RuleActivator ruleActivator, ActiveRuleIndexer activeRuleIndexer) {
        this.dbClient = dbClient;
        this.ruleActivator = ruleActivator;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    @Override
    public List<ActiveRuleChange> update(DbSession dbSession, BuiltInQProfile builtIn, RulesProfileDto rulesProfile) {
        Set deactivatedRuleIds = (Set)this.dbClient.activeRuleDao().selectByRuleProfile(dbSession, rulesProfile).stream().map(ActiveRuleDto::getRuleId).collect(MoreCollectors.toHashSet());
        Set ruleKeys = (Set)Stream.concat(deactivatedRuleIds.stream(), builtIn.getActiveRules().stream().map(BuiltInQProfile.ActiveRule::getRuleId)).collect(MoreCollectors.toSet());
        RuleActivationContext context = this.ruleActivator.createContextForBuiltInProfile(dbSession, rulesProfile, ruleKeys);
        ArrayList<RuleActivation> activations = new ArrayList<RuleActivation>();
        for (BuiltInQProfile.ActiveRule ar : builtIn.getActiveRules()) {
            RuleActivation activation = BuiltInQProfileUpdateImpl.convert(ar);
            activations.add(activation);
            deactivatedRuleIds.remove(activation.getRuleId());
        }
        ArrayList<ActiveRuleChange> changes = new ArrayList<ActiveRuleChange>();
        for (RuleActivation activation : activations) {
            changes.addAll(this.ruleActivator.activate(dbSession, activation, context));
        }
        deactivatedRuleIds.forEach(ruleKey -> changes.addAll(this.ruleActivator.deactivate(dbSession, context, (int)ruleKey, false)));
        this.activeRuleIndexer.commitAndIndex(dbSession, changes);
        return changes;
    }

    private static RuleActivation convert(BuiltInQProfile.ActiveRule ar) {
        Map params = (Map)ar.getBuiltIn().overriddenParams().stream().collect(MoreCollectors.uniqueIndex(BuiltInQualityProfilesDefinition.OverriddenParam::key, BuiltInQualityProfilesDefinition.OverriddenParam::overriddenValue));
        return RuleActivation.create(ar.getRuleId(), ar.getBuiltIn().overriddenSeverity(), params);
    }
}

