/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileRepository;

public class BuiltInQProfileRepositoryImpl
implements BuiltInQProfileRepository {
    private static final Logger LOGGER = Loggers.get(BuiltInQProfileRepositoryImpl.class);
    private static final String DEFAULT_PROFILE_NAME = "Sonar way";
    private final DbClient dbClient;
    private final Languages languages;
    private final List<BuiltInQualityProfilesDefinition> definitions;
    private List<BuiltInQProfile> qProfiles;

    public BuiltInQProfileRepositoryImpl(DbClient dbClient, Languages languages) {
        this(dbClient, languages, new BuiltInQualityProfilesDefinition[0]);
    }

    public BuiltInQProfileRepositoryImpl(DbClient dbClient, Languages languages, BuiltInQualityProfilesDefinition ... definitions) {
        this.dbClient = dbClient;
        this.languages = languages;
        this.definitions = ImmutableList.copyOf((Object[])definitions);
    }

    @Override
    public void initialize() {
        Preconditions.checkState((this.qProfiles == null ? 1 : 0) != 0, (Object)"initialize must be called only once");
        Profiler profiler = Profiler.create((Logger)LOGGER).startInfo("Load quality profiles");
        BuiltInQualityProfilesDefinition.Context context = new BuiltInQualityProfilesDefinition.Context();
        for (BuiltInQualityProfilesDefinition definition : this.definitions) {
            definition.define(context);
        }
        Map<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> rulesProfilesByLanguage = this.validateAndClean(context);
        this.qProfiles = this.toFlatList(rulesProfilesByLanguage);
        this.ensureAllLanguagesHaveAtLeastOneBuiltInQP();
        profiler.stopDebug();
    }

    @Override
    public List<BuiltInQProfile> get() {
        Preconditions.checkState((this.qProfiles != null ? 1 : 0) != 0, (Object)"initialize must be called first");
        return this.qProfiles;
    }

    private void ensureAllLanguagesHaveAtLeastOneBuiltInQP() {
        Set languagesWithBuiltInQProfiles = this.qProfiles.stream().map(BuiltInQProfile::getLanguage).collect(Collectors.toSet());
        Set languagesWithoutBuiltInQProfiles = Arrays.stream(this.languages.all()).map(Language::getKey).filter(key -> !languagesWithBuiltInQProfiles.contains(key)).collect(Collectors.toSet());
        Preconditions.checkState((boolean)languagesWithoutBuiltInQProfiles.isEmpty(), (String)"The following languages have no built-in quality profiles: %s", (Object[])new Object[]{languagesWithoutBuiltInQProfiles.stream().collect(Collectors.joining())});
    }

    private Map<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> validateAndClean(BuiltInQualityProfilesDefinition.Context context) {
        Map profilesByLanguageAndName = context.profilesByLanguageAndName();
        profilesByLanguageAndName.entrySet().removeIf(entry -> {
            String language = (String)entry.getKey();
            if (this.languages.get(language) == null) {
                LOGGER.info("Language {} is not installed, related quality profiles are ignored", (Object)language);
                return true;
            }
            return false;
        });
        return profilesByLanguageAndName;
    }

    private List<BuiltInQProfile> toFlatList(Map<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> rulesProfilesByLanguage) {
        if (rulesProfilesByLanguage.isEmpty()) {
            return Collections.emptyList();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map rulesByRuleKey = (Map)this.dbClient.ruleDao().selectAllDefinitions(dbSession).stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getKey));
            Map buildersByLanguage = (Map)rulesProfilesByLanguage.entrySet().stream().collect(MoreCollectors.uniqueIndex(Map.Entry::getKey, rulesProfilesByLanguageAndName -> BuiltInQProfileRepositoryImpl.toQualityProfileBuilders(rulesProfilesByLanguageAndName, rulesByRuleKey)));
            List list = (List)buildersByLanguage.entrySet().stream().filter(BuiltInQProfileRepositoryImpl::ensureAtMostOneDeclaredDefault).map(entry -> BuiltInQProfileRepositoryImpl.toQualityProfiles((List)entry.getValue())).flatMap(Collection::stream).collect(MoreCollectors.toList());
            return list;
        }
    }

    private static List<BuiltInQProfile.Builder> toQualityProfileBuilders(Map.Entry<String, Map<String, BuiltInQualityProfilesDefinition.BuiltInQualityProfile>> rulesProfilesByLanguageAndName, Map<RuleKey, RuleDefinitionDto> rulesByRuleKey) {
        String language = rulesProfilesByLanguageAndName.getKey();
        LinkedHashMap<String, BuiltInQProfile.Builder> qualityProfileBuildersByName = new LinkedHashMap<String, BuiltInQProfile.Builder>();
        for (BuiltInQualityProfilesDefinition.BuiltInQualityProfile builtInProfile : rulesProfilesByLanguageAndName.getValue().values()) {
            qualityProfileBuildersByName.compute(builtInProfile.name(), (name, existingBuilder) -> BuiltInQProfileRepositoryImpl.updateOrCreateBuilder(language, existingBuilder, builtInProfile, rulesByRuleKey));
        }
        return ImmutableList.copyOf(qualityProfileBuildersByName.values());
    }

    private static boolean ensureAtMostOneDeclaredDefault(Map.Entry<String, List<BuiltInQProfile.Builder>> entry) {
        Set declaredDefaultProfileNames = (Set)entry.getValue().stream().filter(BuiltInQProfile.Builder::isDeclaredDefault).map(BuiltInQProfile.Builder::getName).collect(MoreCollectors.toSet());
        Preconditions.checkState((declaredDefaultProfileNames.size() <= 1 ? 1 : 0) != 0, (String)"Several Quality profiles are flagged as default for the language %s: %s", (Object[])new Object[]{entry.getKey(), declaredDefaultProfileNames});
        return true;
    }

    private static BuiltInQProfile.Builder updateOrCreateBuilder(String language, @Nullable BuiltInQProfile.Builder existingBuilder, BuiltInQualityProfilesDefinition.BuiltInQualityProfile builtInProfile, Map<RuleKey, RuleDefinitionDto> rulesByRuleKey) {
        BuiltInQProfile.Builder builder = BuiltInQProfileRepositoryImpl.createOrReuseBuilder(existingBuilder, language, builtInProfile);
        builder.setDeclaredDefault(builtInProfile.isDefault());
        builtInProfile.rules().forEach(builtInActiveRule -> {
            RuleKey ruleKey = RuleKey.of((String)builtInActiveRule.repoKey(), (String)builtInActiveRule.ruleKey());
            RuleDefinitionDto ruleDefinition = (RuleDefinitionDto)rulesByRuleKey.get(ruleKey);
            Preconditions.checkState((ruleDefinition != null ? 1 : 0) != 0, (String)"Rule with key '%s' not found", (Object[])new Object[]{ruleKey});
            builder.addRule((BuiltInQualityProfilesDefinition.BuiltInActiveRule)builtInActiveRule, ruleDefinition.getId());
        });
        return builder;
    }

    private static BuiltInQProfile.Builder createOrReuseBuilder(@Nullable BuiltInQProfile.Builder existingBuilder, String language, BuiltInQualityProfilesDefinition.BuiltInQualityProfile builtInProfile) {
        if (existingBuilder == null) {
            return new BuiltInQProfile.Builder().setLanguage(language).setName(builtInProfile.name());
        }
        return existingBuilder;
    }

    private static List<BuiltInQProfile> toQualityProfiles(List<BuiltInQProfile.Builder> builders) {
        if (builders.stream().noneMatch(BuiltInQProfile.Builder::isDeclaredDefault)) {
            Optional<BuiltInQProfile.Builder> sonarWayProfile = builders.stream().filter(builder -> builder.getName().equals(DEFAULT_PROFILE_NAME)).findFirst();
            if (sonarWayProfile.isPresent()) {
                sonarWayProfile.get().setComputedDefault(true);
            } else {
                builders.iterator().next().setComputedDefault(true);
            }
        }
        return (List)builders.stream().map(BuiltInQProfile.Builder::build).collect(MoreCollectors.toList((int)builders.size()));
    }
}

