/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.ProjectQgateAssociation;
import org.sonar.db.qualitygate.ProjectQgateAssociationDto;
import org.sonar.db.qualitygate.ProjectQgateAssociationQuery;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class SearchAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private QualityGateFinder qualityGateFinder;
    private final QualityGatesWsSupport wsSupport;

    public SearchAction(DbClient dbClient, UserSession userSession, QualityGateFinder qualityGateFinder, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.qualityGateFinder = qualityGateFinder;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("search").setDescription("Search for projects associated (or not) to a quality gate.<br/>Only authorized projects for current user will be returned.").setSince("4.3").setResponseExample(Resources.getResource(this.getClass(), (String)"search-example.json")).setHandler((RequestHandler)this);
        action.createParam("gateId").setDescription("Quality Gate ID").setRequired(true).setExampleValue((Object)"1");
        action.createParam("query").setDescription("To search for projects containing this string. If this parameter is set, \"selected\" is set to \"all\".").setExampleValue((Object)"abc");
        action.addSelectionModeParam();
        action.createParam("page").setDescription("Page number").setDefaultValue((Object)"1").setExampleValue((Object)"2");
        action.createParam("pageSize").setDescription("Page size").setExampleValue((Object)"10");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QGateWithOrgDto qualityGate = this.qualityGateFinder.getByOrganizationAndId(dbSession, organization, request.mandatoryParamAsLong("gateId"));
            Association associations = this.find(dbSession, ProjectQgateAssociationQuery.builder().qualityGate(qualityGate).membership(request.param("query") == null ? request.param("selected") : "all").projectSearch(request.param("query")).pageIndex(request.paramAsInt("page")).pageSize(request.paramAsInt("pageSize")).build());
            Qualitygates.SearchResponse.Builder createResponse = Qualitygates.SearchResponse.newBuilder().setMore(associations.hasMoreResults());
            for (ProjectQgateAssociation project : associations.projects()) {
                createResponse.addResultsBuilder().setId(project.id().longValue()).setName(project.name()).setSelected(project.isMember());
            }
            WsUtils.writeProtobuf((Message)createResponse.build(), request, response);
        }
    }

    private Association find(DbSession dbSession, ProjectQgateAssociationQuery query) {
        List projects = this.dbClient.projectQgateAssociationDao().selectProjects(dbSession, query);
        List<ProjectQgateAssociationDto> authorizedProjects = this.keepAuthorizedProjects(dbSession, projects);
        Paging paging = Paging.forPageIndex((int)query.pageIndex()).withPageSize(query.pageSize()).andTotal(authorizedProjects.size());
        return new Association(SearchAction.toProjectAssociations(SearchAction.getPaginatedProjects(authorizedProjects, paging)), paging.hasNextPage());
    }

    private static List<ProjectQgateAssociationDto> getPaginatedProjects(List<ProjectQgateAssociationDto> projects, Paging paging) {
        return (List)projects.stream().skip(paging.offset()).limit(paging.pageSize()).collect(MoreCollectors.toList());
    }

    private static List<ProjectQgateAssociation> toProjectAssociations(List<ProjectQgateAssociationDto> dtos) {
        return (List)dtos.stream().map(ProjectQgateAssociationDto::toQgateAssociation).collect(MoreCollectors.toList());
    }

    private List<ProjectQgateAssociationDto> keepAuthorizedProjects(DbSession dbSession, List<ProjectQgateAssociationDto> projects) {
        if (this.userSession.isRoot()) {
            return projects;
        }
        List projectIds = (List)projects.stream().map(ProjectQgateAssociationDto::getId).collect(MoreCollectors.toList());
        Set authorizedProjectIds = this.dbClient.authorizationDao().keepAuthorizedProjectIds(dbSession, (Collection)projectIds, this.userSession.getUserId(), "user");
        return (List)projects.stream().filter(project -> authorizedProjectIds.contains(project.getId())).collect(MoreCollectors.toList());
    }

    private static class Association {
        private List<ProjectQgateAssociation> projects;
        private boolean hasMoreResults;

        private Association(List<ProjectQgateAssociation> projects, boolean hasMoreResults) {
            this.projects = projects;
            this.hasMoreResults = hasMoreResults;
        }

        public List<ProjectQgateAssociation> projects() {
            return this.projects;
        }

        public boolean hasMoreResults() {
            return this.hasMoreResults;
        }
    }
}

