/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class CreateConditionAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final QualityGateFinder qualityGateFinder;
    private final QualityGatesWsSupport wsSupport;

    public CreateConditionAction(DbClient dbClient, QualityGateConditionsUpdater qualityGateConditionsUpdater, QualityGateFinder qualityGateFinder, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.qualityGateFinder = qualityGateFinder;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("create_condition").setPost(true).setDescription("Add a new condition to a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setResponseExample(this.getClass().getResource("create-condition-example.json")).setHandler((RequestHandler)this);
        createCondition.createParam("gateId").setRequired(true).setDescription("ID of the quality gate").setExampleValue((Object)"1");
        QualityGatesWs.addConditionParams(createCondition);
        this.wsSupport.createOrganizationParam(createCondition);
    }

    public void handle(Request request, Response response) {
        int gateId = request.mandatoryParamAsInt("gateId");
        String metric = request.mandatoryParam("metric");
        String operator = request.mandatoryParam("op");
        String warning = request.param("warning");
        String error = request.param("error");
        Integer period = request.paramAsInt("period");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QGateWithOrgDto qualityGate = this.qualityGateFinder.getByOrganizationAndId(dbSession, organization, gateId);
            this.wsSupport.checkCanEdit(qualityGate);
            QualityGateConditionDto condition = this.qualityGateConditionsUpdater.createCondition(dbSession, (QualityGateDto)qualityGate, metric, operator, Strings.emptyToNull((String)warning), Strings.emptyToNull((String)error), period);
            Qualitygates.CreateConditionResponse.Builder createConditionResponse = Qualitygates.CreateConditionResponse.newBuilder().setId(condition.getId()).setMetric(condition.getMetricKey()).setOp(condition.getOperator());
            Protobuf.setNullable((Object)condition.getWarningThreshold(), arg_0 -> ((Qualitygates.CreateConditionResponse.Builder)createConditionResponse).setWarning(arg_0));
            Protobuf.setNullable((Object)condition.getErrorThreshold(), arg_0 -> ((Qualitygates.CreateConditionResponse.Builder)createConditionResponse).setError(arg_0));
            Protobuf.setNullable((Object)condition.getPeriod(), arg_0 -> ((Qualitygates.CreateConditionResponse.Builder)createConditionResponse).setPeriod(arg_0));
            WsUtils.writeProtobuf((Message)createConditionResponse.build(), request, response);
            dbSession.commit();
        }
    }
}

