/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateUpdater;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class CreateAction
implements QualityGatesWsAction {
    public static final int NAME_MAXIMUM_LENGTH = 100;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QualityGateUpdater qualityGateUpdater;
    private final QualityGatesWsSupport wsSupport;

    public CreateAction(DbClient dbClient, UserSession userSession, QualityGateUpdater qualityGateUpdater, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.qualityGateUpdater = qualityGateUpdater;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("create").setPost(true).setDescription("Create a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setResponseExample(this.getClass().getResource("create-example.json")).setHandler((RequestHandler)this);
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(100)).setDescription("The name of the quality gate to create").setExampleValue((Object)"My Quality Gate");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organizationDto = this.wsSupport.getOrganization(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, organizationDto.getUuid());
            String name = request.mandatoryParam("name");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"The 'name' parameter is empty");
            QualityGateDto newQualityGate = this.qualityGateUpdater.create(dbSession, organizationDto, name);
            Qualitygates.CreateResponse.Builder createResponse = Qualitygates.CreateResponse.newBuilder().setId(newQualityGate.getId().longValue()).setName(newQualityGate.getName());
            dbSession.commit();
            WsUtils.writeProtobuf((Message)createResponse.build(), request, response);
        }
    }
}

