/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.changeevent;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.Metric;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.qualitygate.EvaluatedQualityGate;

@Immutable
public class QGChangeEvent {
    private final ComponentDto project;
    private final BranchDto branch;
    private final SnapshotDto analysis;
    private final Configuration projectConfiguration;
    private final Metric.Level previousStatus;
    private final Supplier<Optional<EvaluatedQualityGate>> qualityGateSupplier;

    public QGChangeEvent(ComponentDto project, BranchDto branch, SnapshotDto analysis, Configuration projectConfiguration, @Nullable Metric.Level previousStatus, Supplier<Optional<EvaluatedQualityGate>> qualityGateSupplier) {
        this.project = Objects.requireNonNull(project, "project can't be null");
        this.branch = Objects.requireNonNull(branch, "branch can't be null");
        this.analysis = Objects.requireNonNull(analysis, "analysis can't be null");
        this.projectConfiguration = Objects.requireNonNull(projectConfiguration, "projectConfiguration can't be null");
        this.previousStatus = previousStatus;
        this.qualityGateSupplier = Objects.requireNonNull(qualityGateSupplier, "qualityGateSupplier can't be null");
    }

    public BranchDto getBranch() {
        return this.branch;
    }

    public ComponentDto getProject() {
        return this.project;
    }

    public SnapshotDto getAnalysis() {
        return this.analysis;
    }

    public Configuration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public Optional<Metric.Level> getPreviousStatus() {
        return Optional.ofNullable(this.previousStatus);
    }

    public Supplier<Optional<EvaluatedQualityGate>> getQualityGateSupplier() {
        return this.qualityGateSupplier;
    }

    public String toString() {
        return "QGChangeEvent{project=" + QGChangeEvent.toString(this.project) + ", branch=" + QGChangeEvent.toString(this.branch) + ", analysis=" + QGChangeEvent.toString(this.analysis) + ", projectConfiguration=" + this.projectConfiguration + ", previousStatus=" + this.previousStatus + ", qualityGateSupplier=" + this.qualityGateSupplier + '}';
    }

    private static String toString(ComponentDto project) {
        return project.uuid() + ":" + project.getKey();
    }

    private static String toString(BranchDto branch) {
        return branch.getBranchType() + ":" + branch.getUuid() + ":" + branch.getProjectUuid() + ":" + branch.getMergeBranchUuid();
    }

    private static String toString(SnapshotDto analysis) {
        return analysis.getUuid() + ":" + analysis.getCreatedAt();
    }
}

