/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.component.ProjectLinkDto;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.SearchMyProjectsData;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Projects;

public class SearchMyProjectsAction
implements ProjectsWsAction {
    private static final int MAX_SIZE = 500;
    private final DbClient dbClient;
    private final UserSession userSession;

    public SearchMyProjectsAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_my_projects").setDescription("Return list of projects for which the current user has 'Administer' permission. Maximum 1'000 projects are returned.").setResponseExample(this.getClass().getResource("search_my_projects-example.json")).addPagingParams(100, 500).setSince("6.0").setInternal(true).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.4", "The 'id' field is deprecated in the response")});
    }

    public void handle(Request request, Response response) throws Exception {
        Projects.SearchMyProjectsWsResponse searchMyProjectsWsResponse = this.doHandle(SearchMyProjectsAction.toRequest(request));
        WsUtils.writeProtobuf((Message)searchMyProjectsWsResponse, request, response);
    }

    private Projects.SearchMyProjectsWsResponse doHandle(SearchMyProjectsRequest request) {
        this.checkAuthenticated();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SearchMyProjectsData data = this.load(dbSession, request);
            Projects.SearchMyProjectsWsResponse searchMyProjectsWsResponse = SearchMyProjectsAction.buildResponse(request, data);
            return searchMyProjectsWsResponse;
        }
    }

    private static Projects.SearchMyProjectsWsResponse buildResponse(SearchMyProjectsRequest request, SearchMyProjectsData data) {
        Projects.SearchMyProjectsWsResponse.Builder response = Projects.SearchMyProjectsWsResponse.newBuilder();
        ProjectDtoToWs projectDtoToWs = new ProjectDtoToWs(data);
        data.projects().stream().map(projectDtoToWs).forEach(arg_0 -> ((Projects.SearchMyProjectsWsResponse.Builder)response).addProjects(arg_0));
        response.getPagingBuilder().setPageIndex(request.getPage().intValue()).setPageSize(request.getPageSize().intValue()).setTotal(data.totalNbOfProjects()).build();
        return response.build();
    }

    private void checkAuthenticated() {
        this.userSession.checkLoggedIn();
    }

    private static SearchMyProjectsRequest toRequest(Request request) {
        return SearchMyProjectsRequest.builder().setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).build();
    }

    SearchMyProjectsData load(DbSession dbSession, SearchMyProjectsRequest request) {
        SearchMyProjectsData.Builder data = SearchMyProjectsData.builder();
        ProjectsResult searchResult = this.searchProjects(dbSession, request);
        List projects = searchResult.projects;
        List projectUuids = Lists.transform((List)projects, ComponentDto::projectUuid);
        List projectLinks = this.dbClient.projectLinkDao().selectByProjectUuids(dbSession, projectUuids);
        List snapshots = this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, (Collection)projectUuids);
        List qualityGates = this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricKeys(dbSession, (Collection)projectUuids, Collections.singletonList("alert_status"));
        data.setProjects(projects).setProjectLinks(projectLinks).setSnapshots(snapshots).setQualityGates(qualityGates).setTotalNbOfProjects(searchResult.total);
        return data.build();
    }

    @VisibleForTesting
    ProjectsResult searchProjects(DbSession dbSession, SearchMyProjectsRequest request) {
        int userId = Objects.requireNonNull(this.userSession.getUserId(), "Current user must be authenticated");
        List componentIds = this.dbClient.roleDao().selectComponentIdsByPermissionAndUserId(dbSession, "admin", userId);
        ComponentQuery dbQuery = ComponentQuery.builder().setQualifiers(new String[]{"TRK"}).setComponentIds((Set)ImmutableSet.copyOf(componentIds.subList(0, Math.min(componentIds.size(), 1000)))).build();
        return new ProjectsResult(this.dbClient.componentDao().selectByQuery(dbSession, dbQuery, Paging.offset((int)request.getPage(), (int)request.getPageSize()), request.getPageSize().intValue()), this.dbClient.componentDao().countByQuery(dbSession, dbQuery));
    }

    private static class Builder {
        private Integer page;
        private Integer pageSize;

        private Builder() {
        }

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchMyProjectsRequest build() {
            return new SearchMyProjectsRequest(this);
        }
    }

    private static class SearchMyProjectsRequest {
        private final Integer page;
        private final Integer pageSize;

        private SearchMyProjectsRequest(Builder builder) {
            this.page = builder.page;
            this.pageSize = builder.pageSize;
        }

        @CheckForNull
        public Integer getPage() {
            return this.page;
        }

        @CheckForNull
        public Integer getPageSize() {
            return this.pageSize;
        }

        public static Builder builder() {
            return new Builder();
        }
    }

    private static class ProjectsResult {
        private final List<ComponentDto> projects;
        private final int total;

        private ProjectsResult(List<ComponentDto> projects, int total) {
            this.projects = projects;
            this.total = total;
        }
    }

    private static enum ProjectLinkDtoToWs implements Function<ProjectLinkDto, Projects.SearchMyProjectsWsResponse.Link>
    {
        INSTANCE;


        @Override
        public Projects.SearchMyProjectsWsResponse.Link apply(ProjectLinkDto dto) {
            Projects.SearchMyProjectsWsResponse.Link.Builder link = Projects.SearchMyProjectsWsResponse.Link.newBuilder();
            link.setHref(dto.getHref());
            if (!Strings.isNullOrEmpty((String)dto.getName())) {
                link.setName(dto.getName());
            }
            if (!Strings.isNullOrEmpty((String)dto.getType())) {
                link.setType(dto.getType());
            }
            return link.build();
        }
    }

    private static class ProjectDtoToWs
    implements Function<ComponentDto, Projects.SearchMyProjectsWsResponse.Project> {
        private final SearchMyProjectsData data;

        private ProjectDtoToWs(SearchMyProjectsData data) {
            this.data = data;
        }

        @Override
        public Projects.SearchMyProjectsWsResponse.Project apply(ComponentDto dto) {
            Projects.SearchMyProjectsWsResponse.Project.Builder project = Projects.SearchMyProjectsWsResponse.Project.newBuilder();
            project.setId(dto.uuid()).setKey(dto.getDbKey()).setName(dto.name());
            this.data.lastAnalysisDateFor(dto.uuid()).ifPresent(arg_0 -> ((Projects.SearchMyProjectsWsResponse.Project.Builder)project).setLastAnalysisDate(arg_0));
            this.data.qualityGateStatusFor(dto.uuid()).ifPresent(arg_0 -> ((Projects.SearchMyProjectsWsResponse.Project.Builder)project).setQualityGate(arg_0));
            Protobuf.setNullable((Object)Strings.emptyToNull((String)dto.description()), arg_0 -> ((Projects.SearchMyProjectsWsResponse.Project.Builder)project).setDescription(arg_0));
            this.data.projectLinksFor(dto.uuid()).stream().map(ProjectLinkDtoToWs.INSTANCE).forEach(arg_0 -> ((Projects.SearchMyProjectsWsResponse.Project.Builder)project).addLinks(arg_0));
            return project.build();
        }
    }
}

