/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.ProjectsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Components;

public class ProvisionedAction
implements ProjectsWsAction {
    private static final Set<String> POSSIBLE_FIELDS = Sets.newHashSet((Object[])new String[]{"uuid", "key", "name", "creationDate", "visibility"});
    private final ProjectsWsSupport support;
    private final DbClient dbClient;
    private final UserSession userSession;

    public ProvisionedAction(ProjectsWsSupport support, DbClient dbClient, UserSession userSession) {
        this.support = support;
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("provisioned");
        action.setDescription("Get the list of provisioned projects.<br> Web service is deprecated. Use api/projects/search instead, with onProvisionedOnly=true.<br> Require 'Create Projects' permission.").setSince("5.2").setDeprecatedSince("6.6").setResponseExample(Resources.getResource(this.getClass(), (String)"provisioned-example.json")).setHandler((RequestHandler)this).addPagingParams(100, 500).addSearchQuery("sonar", new String[]{"names", "keys"}).addFieldsParam(POSSIBLE_FIELDS);
        action.setChangelog(new Change[]{new Change("6.4", "The 'uuid' field is deprecated in the response"), new Change("6.4", "Paging response fields is now in a Paging object")});
        this.support.addOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        int page = request.mandatoryParamAsInt("p");
        int pageSize = request.mandatoryParamAsInt("ps");
        Set<String> desiredFields = ProvisionedAction.desiredFields(request);
        String query = request.param("q");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.support.getOrganization(dbSession, request.param("organization"));
            this.userSession.checkPermission(OrganizationPermission.PROVISION_PROJECTS, organization);
            ComponentQuery dbQuery = ProvisionedAction.buildDbQuery(query);
            List projects = this.dbClient.componentDao().selectByQuery(dbSession, organization.getUuid(), dbQuery, Paging.offset((int)page, (int)pageSize), pageSize);
            int nbOfProjects = this.dbClient.componentDao().countByQuery(dbSession, organization.getUuid(), dbQuery);
            Components.ProvisionedWsResponse result = Components.ProvisionedWsResponse.newBuilder().addAllProjects(ProvisionedAction.writeProjects(projects, desiredFields)).setPaging(Common.Paging.newBuilder().setTotal(nbOfProjects).setPageIndex(page).setPageSize(pageSize)).build();
            WsUtils.writeProtobuf((Message)result, request, response);
        }
    }

    private static ComponentQuery buildDbQuery(@Nullable String nameOrKeyQuery) {
        ComponentQuery.Builder dbQuery = ComponentQuery.builder().setQualifiers(new String[]{"TRK"}).setOnProvisionedOnly(true);
        Protobuf.setNullable((Object)nameOrKeyQuery, q -> {
            dbQuery.setPartialMatchOnKey(Boolean.valueOf(true));
            dbQuery.setNameOrKeyQuery(q);
            return dbQuery;
        });
        return dbQuery.build();
    }

    private static List<Components.ProvisionedWsResponse.Component> writeProjects(List<ComponentDto> projects, Set<String> desiredFields) {
        return (List)projects.stream().map(project -> {
            Components.ProvisionedWsResponse.Component.Builder compBuilder = Components.ProvisionedWsResponse.Component.newBuilder().setUuid(project.uuid());
            ProvisionedAction.writeIfNeeded("key", project.getDbKey(), arg_0 -> ((Components.ProvisionedWsResponse.Component.Builder)compBuilder).setKey(arg_0), desiredFields);
            ProvisionedAction.writeIfNeeded("name", project.name(), arg_0 -> ((Components.ProvisionedWsResponse.Component.Builder)compBuilder).setName(arg_0), desiredFields);
            ProvisionedAction.writeIfNeeded("creationDate", project.getCreatedAt(), arg_0 -> ((Components.ProvisionedWsResponse.Component.Builder)compBuilder).setCreationDate(arg_0), desiredFields);
            ProvisionedAction.writeIfNeeded("visibility", project.isPrivate() ? Visibility.PRIVATE.getLabel() : Visibility.PUBLIC.getLabel(), arg_0 -> ((Components.ProvisionedWsResponse.Component.Builder)compBuilder).setVisibility(arg_0), desiredFields);
            return compBuilder.build();
        }).collect(MoreCollectors.toList());
    }

    private static void writeIfNeeded(String fieldName, String value, Consumer<String> setter, Set<String> desiredFields) {
        if (desiredFields.contains(fieldName)) {
            setter.accept(value);
        }
    }

    private static void writeIfNeeded(String fieldName, @Nullable Date value, Consumer<String> setter, Set<String> desiredFields) {
        if (desiredFields.contains(fieldName)) {
            Optional.ofNullable(value).map(DateUtils::formatDateTime).ifPresent(setter);
        }
    }

    private static Set<String> desiredFields(Request request) {
        List desiredFields = request.paramAsStrings("f");
        if (desiredFields == null) {
            return POSSIBLE_FIELDS;
        }
        return Sets.newHashSet((Iterable)desiredFields);
    }
}

