/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.project.Project;
import org.sonar.server.project.ProjectLifeCycleListener;
import org.sonar.server.project.ProjectLifeCycleListeners;
import org.sonar.server.project.RekeyedProject;

public class ProjectLifeCycleListenersImpl
implements ProjectLifeCycleListeners {
    private static final Logger LOG = Loggers.get(ProjectLifeCycleListenersImpl.class);
    private final ProjectLifeCycleListener[] listeners;

    public ProjectLifeCycleListenersImpl() {
        this.listeners = new ProjectLifeCycleListener[0];
    }

    public ProjectLifeCycleListenersImpl(ProjectLifeCycleListener[] listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onProjectsDeleted(Set<Project> projects) {
        Preconditions.checkNotNull(projects, (Object)"projects can't be null");
        if (projects.isEmpty()) {
            return;
        }
        Arrays.stream(this.listeners).forEach(ProjectLifeCycleListenersImpl.safelyCallListener(listener -> listener.onProjectsDeleted(projects)));
    }

    @Override
    public void onProjectsRekeyed(Set<RekeyedProject> rekeyedProjects) {
        Preconditions.checkNotNull(rekeyedProjects, (Object)"rekeyedProjects can't be null");
        if (rekeyedProjects.isEmpty()) {
            return;
        }
        Arrays.stream(this.listeners).forEach(ProjectLifeCycleListenersImpl.safelyCallListener(listener -> listener.onProjectsRekeyed(rekeyedProjects)));
    }

    private static Consumer<ProjectLifeCycleListener> safelyCallListener(Consumer<ProjectLifeCycleListener> task) {
        return listener -> {
            try {
                task.accept((ProjectLifeCycleListener)listener);
            }
            catch (Error | Exception e) {
                LOG.error("Call on ProjectLifeCycleListener \"{}\" failed", listener.getClass(), (Object)e);
            }
        };
    }
}

