/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.plugins.PluginDownloader;
import org.sonar.server.plugins.PluginUninstaller;
import org.sonar.server.plugins.ws.PluginsWsAction;
import org.sonar.server.user.UserSession;

public class CancelAllAction
implements PluginsWsAction {
    private final PluginDownloader pluginDownloader;
    private final PluginUninstaller pluginUninstaller;
    private final UserSession userSession;

    public CancelAllAction(PluginDownloader pluginDownloader, PluginUninstaller pluginUninstaller, UserSession userSession) {
        this.pluginDownloader = pluginDownloader;
        this.pluginUninstaller = pluginUninstaller;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("cancel_all").setPost(true).setSince("5.2").setDescription("Cancels any operation pending on any plugin (install, update or uninstall)<br/>Requires user to be authenticated with Administer System permissions").setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        this.pluginDownloader.cancelDownloads();
        this.pluginUninstaller.cancelUninstalls();
        response.noContent();
    }
}

