/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.platform.ws.HealthActionSupport;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.SystemPasscode;
import org.sonar.server.ws.WsUtils;

public class SafeModeHealthAction
implements SystemWsAction {
    private final HealthActionSupport support;
    private final SystemPasscode systemPasscode;

    public SafeModeHealthAction(HealthActionSupport support, SystemPasscode systemPasscode) {
        this.support = support;
        this.systemPasscode = systemPasscode;
    }

    public void define(WebService.NewController controller) {
        this.support.define(controller, this);
    }

    public void handle(Request request, Response response) throws Exception {
        if (!this.systemPasscode.isConfigured() || !this.systemPasscode.isValid(request)) {
            throw new ForbiddenException("Insufficient privileges");
        }
        WsUtils.writeProtobuf((Message)this.support.checkNodeHealth(), request, response);
    }
}

