/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheControlFilter
implements Filter {
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final int ONE_YEAR_IN_SECONDS = 31536000;
    private static final int FIVE_MINUTES_IN_SECONDS = 300;
    private static final String MAX_AGE_TEMPLATE = "max-age=%d";
    private static final Map<String, Integer> MAX_AGE_BY_PATH = ImmutableMap.of((Object)"/js/", (Object)31536000, (Object)"/css/", (Object)31536000, (Object)"/static/", (Object)300, (Object)"/images/", (Object)300);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)req).getRequestURI().replaceFirst(((HttpServletRequest)req).getContextPath(), "");
        MAX_AGE_BY_PATH.entrySet().stream().filter(m -> path.startsWith((String)m.getKey())).map(Map.Entry::getValue).findFirst().ifPresent(maxAge -> ((HttpServletResponse)resp).addHeader(CACHE_CONTROL_HEADER, String.format(MAX_AGE_TEMPLATE, maxAge)));
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }
}

