/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.db.EmbeddedDatabase;

public class EmbeddedDatabaseFactory
implements Startable {
    private static final String URL_PREFIX = "jdbc:h2:tcp:";
    private final Configuration config;
    private final System2 system2;
    private EmbeddedDatabase embeddedDatabase;

    public EmbeddedDatabaseFactory(Configuration config, System2 system2) {
        this.config = config;
        this.system2 = system2;
    }

    public void start() {
        String jdbcUrl;
        if (this.embeddedDatabase == null && StringUtils.startsWith((String)(jdbcUrl = (String)this.config.get(ProcessProperties.Property.JDBC_URL.getKey()).get()), (String)URL_PREFIX)) {
            this.embeddedDatabase = this.createEmbeddedDatabase();
            this.embeddedDatabase.start();
        }
    }

    public void stop() {
        if (this.embeddedDatabase != null) {
            this.embeddedDatabase.stop();
            this.embeddedDatabase = null;
        }
    }

    @VisibleForTesting
    EmbeddedDatabase createEmbeddedDatabase() {
        return new EmbeddedDatabase(this.config, this.system2);
    }
}

