/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db;

import org.picocontainer.Startable;
import org.sonar.api.platform.ServerUpgradeStatus;
import org.sonar.server.platform.db.migration.charset.DatabaseCharsetChecker;

public class CheckDatabaseCharsetAtStartup
implements Startable {
    private final ServerUpgradeStatus upgradeStatus;
    private final DatabaseCharsetChecker charsetChecker;

    public CheckDatabaseCharsetAtStartup(ServerUpgradeStatus upgradeStatus, DatabaseCharsetChecker charsetChecker) {
        this.upgradeStatus = upgradeStatus;
        this.charsetChecker = charsetChecker;
    }

    public void start() {
        DatabaseCharsetChecker.State state = DatabaseCharsetChecker.State.STARTUP;
        if (this.upgradeStatus.isUpgraded()) {
            state = DatabaseCharsetChecker.State.UPGRADE;
        } else if (this.upgradeStatus.isFreshInstall()) {
            state = DatabaseCharsetChecker.State.FRESH_INSTALL;
        }
        this.charsetChecker.check(state);
    }

    public void stop() {
    }
}

