/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;

public class DefaultMetricFinder
implements MetricFinder {
    private final DbClient dbClient;

    public DefaultMetricFinder(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public Metric findById(int id) {
        try (DbSession session = this.dbClient.openSession(false);){
            MetricDto dto = this.dbClient.metricDao().selectById(session, (long)id);
            if (dto != null && dto.isEnabled()) {
                Metric metric = ToMetric.INSTANCE.apply(dto);
                return metric;
            }
            Metric metric = null;
            return metric;
        }
    }

    public Metric findByKey(String key) {
        try (DbSession session = this.dbClient.openSession(false);){
            MetricDto dto = this.dbClient.metricDao().selectByKey(session, key);
            if (dto != null && dto.isEnabled()) {
                Metric metric = ToMetric.INSTANCE.apply(dto);
                return metric;
            }
            Metric metric = null;
            return metric;
        }
    }

    public Collection<Metric> findAll(List<String> metricKeys) {
        try (DbSession session = this.dbClient.openSession(false);){
            List dtos = this.dbClient.metricDao().selectByKeys(session, metricKeys);
            ImmutableList immutableList = FluentIterable.from((Iterable)dtos).filter((Predicate)IsEnabled.INSTANCE).transform((Function)ToMetric.INSTANCE).toList();
            return immutableList;
        }
    }

    public Collection<Metric> findAll() {
        try (DbSession session = this.dbClient.openSession(false);){
            List dtos = this.dbClient.metricDao().selectEnabled(session);
            ImmutableList immutableList = FluentIterable.from((Iterable)dtos).transform((Function)ToMetric.INSTANCE).toList();
            return immutableList;
        }
    }

    private static enum ToMetric implements Function<MetricDto, Metric>
    {
        INSTANCE;


        public Metric apply(@Nonnull MetricDto dto) {
            Metric metric = new Metric();
            metric.setId(dto.getId());
            metric.setKey(dto.getKey());
            metric.setDescription(dto.getDescription());
            metric.setName(dto.getShortName());
            metric.setBestValue(dto.getBestValue());
            metric.setDomain(dto.getDomain());
            metric.setEnabled(Boolean.valueOf(dto.isEnabled()));
            metric.setDirection(Integer.valueOf(dto.getDirection()));
            metric.setHidden(Boolean.valueOf(dto.isHidden()));
            metric.setQualitative(Boolean.valueOf(dto.isQualitative()));
            metric.setType(Metric.ValueType.valueOf((String)dto.getValueType()));
            metric.setOptimizedBestValue(Boolean.valueOf(dto.isOptimizedBestValue()));
            metric.setUserManaged(Boolean.valueOf(dto.isUserManaged()));
            metric.setWorstValue(dto.getWorstValue());
            return metric;
        }
    }

    private static enum IsEnabled implements Predicate<MetricDto>
    {
        INSTANCE;


        public boolean apply(@Nonnull MetricDto dto) {
            return dto.isEnabled();
        }
    }
}

