/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.component.SnapshotDto;
import org.sonarqube.ws.Measures;

class SnapshotDtoToWsPeriods {
    private SnapshotDtoToWsPeriods() {
    }

    static List<Measures.Period> snapshotToWsPeriods(@Nullable SnapshotDto snapshot) {
        if (snapshot == null) {
            return Collections.emptyList();
        }
        ArrayList<Measures.Period> periods = new ArrayList<Measures.Period>();
        if (snapshot.getPeriodDate() != null) {
            periods.add(SnapshotDtoToWsPeriods.snapshotDtoToWsPeriod(snapshot));
        }
        return periods;
    }

    private static Measures.Period snapshotDtoToWsPeriod(SnapshotDto snapshot) {
        Long periodDate;
        String periodModeParameter;
        Measures.Period.Builder period = Measures.Period.newBuilder();
        period.setIndex(1);
        String periodMode = snapshot.getPeriodMode();
        if (periodMode != null) {
            period.setMode(periodMode);
        }
        if ((periodModeParameter = snapshot.getPeriodModeParameter()) != null) {
            period.setParameter(periodModeParameter);
        }
        if ((periodDate = snapshot.getPeriodDate()) != null) {
            period.setDate(DateUtils.formatDateTime((long)periodDate));
        }
        return period.build();
    }
}

