/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class TagsAction
implements IssuesWsAction {
    private final IssueIndex issueIndex;
    private final RuleIndex ruleIndex;
    private final DbClient dbClient;

    public TagsAction(IssueIndex issueIndex, RuleIndex ruleIndex, DbClient dbClient) {
        this.issueIndex = issueIndex;
        this.ruleIndex = ruleIndex;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("tags").setHandler((RequestHandler)this).setSince("5.1").setDescription("List tags matching a given query").setResponseExample(Resources.getResource(this.getClass(), (String)"tags-example.json"));
        action.createSearchQuery("misra", new String[]{"tags"});
        action.createPageSize(10, 100);
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        String query = request.param("q");
        int pageSize = request.mandatoryParamAsInt("ps");
        OrganizationDto organization = this.getOrganization(request.param("organization"));
        List<String> tags = this.listTags(organization, query, pageSize == 0 ? Integer.MAX_VALUE : pageSize);
        Issues.TagsResponse.Builder tagsResponseBuilder = Issues.TagsResponse.newBuilder();
        tags.forEach(arg_0 -> ((Issues.TagsResponse.Builder)tagsResponseBuilder).addTags(arg_0));
        WsUtils.writeProtobuf((Message)tagsResponseBuilder.build(), request, response);
    }

    private List<String> listTags(@Nullable OrganizationDto organization, @Nullable String textQuery, int pageSize) {
        List<String> issueTags = this.issueIndex.listTags(organization, textQuery, pageSize);
        List<String> ruleTags = this.ruleIndex.listTags(organization, textQuery, pageSize);
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(issueTags);
        result.addAll(ruleTags);
        ArrayList<String> resultAsList = new ArrayList<String>(result);
        return resultAsList.size() > pageSize && pageSize > 0 ? resultAsList.subList(0, pageSize) : resultAsList;
    }

    @CheckForNull
    private OrganizationDto getOrganization(@Nullable String organizationKey) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organizationDto = organizationKey == null ? null : (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization with key '%s'", organizationKey);
            return organizationDto;
        }
    }
}

