/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.plugins.emailnotifications.api.EmailMessage;
import org.sonar.plugins.emailnotifications.api.EmailTemplate;

public class IssueChangesEmailTemplate
extends EmailTemplate {
    private static final char NEW_LINE = '\n';
    private final DbClient dbClient;
    private final EmailSettings settings;

    public IssueChangesEmailTemplate(DbClient dbClient, EmailSettings settings) {
        this.dbClient = dbClient;
        this.settings = settings;
    }

    public EmailMessage format(Notification notif) {
        if (!"issue-changes".equals(notif.getType())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        IssueChangesEmailTemplate.appendHeader(notif, sb);
        sb.append('\n');
        IssueChangesEmailTemplate.appendChanges(notif, sb);
        sb.append('\n');
        this.appendFooter(sb, notif);
        String projectName = notif.getFieldValue("projectName");
        String issueKey = notif.getFieldValue("key");
        String author = notif.getFieldValue("changeAuthor");
        EmailMessage message = new EmailMessage().setMessageId("issue-changes/" + issueKey).setSubject(projectName + ", change on issue #" + issueKey).setMessage(sb.toString());
        if (author != null) {
            message.setFrom(this.getUserFullName(author));
        }
        return message;
    }

    private static void appendChanges(Notification notif, StringBuilder sb) {
        IssueChangesEmailTemplate.appendField(sb, "Comment", null, notif.getFieldValue("comment"));
        IssueChangesEmailTemplate.appendFieldWithoutHistory(sb, "Assignee", notif.getFieldValue("old.assignee"), notif.getFieldValue("new.assignee"));
        IssueChangesEmailTemplate.appendField(sb, "Severity", notif.getFieldValue("old.severity"), notif.getFieldValue("new.severity"));
        IssueChangesEmailTemplate.appendField(sb, "Type", notif.getFieldValue("old.type"), notif.getFieldValue("new.type"));
        IssueChangesEmailTemplate.appendField(sb, "Resolution", notif.getFieldValue("old.resolution"), notif.getFieldValue("new.resolution"));
        IssueChangesEmailTemplate.appendField(sb, "Status", notif.getFieldValue("old.status"), notif.getFieldValue("new.status"));
        IssueChangesEmailTemplate.appendField(sb, "Message", notif.getFieldValue("old.message"), notif.getFieldValue("new.message"));
        IssueChangesEmailTemplate.appendField(sb, "Author", notif.getFieldValue("old.author"), notif.getFieldValue("new.author"));
        IssueChangesEmailTemplate.appendFieldWithoutHistory(sb, "Action Plan", notif.getFieldValue("old.actionPlan"), notif.getFieldValue("new.actionPlan"));
        IssueChangesEmailTemplate.appendField(sb, "Tags", IssueChangesEmailTemplate.formatTagChange(notif.getFieldValue("old.tags")), IssueChangesEmailTemplate.formatTagChange(notif.getFieldValue("new.tags")));
    }

    @CheckForNull
    private static String formatTagChange(@Nullable String tags) {
        if (tags == null) {
            return null;
        }
        return "[" + tags + "]";
    }

    private static void appendHeader(Notification notif, StringBuilder sb) {
        String pullRequest;
        IssueChangesEmailTemplate.appendLine(sb, StringUtils.defaultString((String)notif.getFieldValue("componentName"), (String)notif.getFieldValue("componentKey")));
        String branchName = notif.getFieldValue("branch");
        if (branchName != null) {
            IssueChangesEmailTemplate.appendField(sb, "Branch", null, branchName);
        }
        if ((pullRequest = notif.getFieldValue("pullRequest")) != null) {
            IssueChangesEmailTemplate.appendField(sb, "Pull request", null, pullRequest);
        }
        IssueChangesEmailTemplate.appendField(sb, "Rule", null, notif.getFieldValue("ruleName"));
        IssueChangesEmailTemplate.appendField(sb, "Message", null, notif.getFieldValue("message"));
    }

    private void appendFooter(StringBuilder sb, Notification notification) {
        String issueKey = notification.getFieldValue("key");
        try {
            String pullRequest;
            sb.append("More details at: ").append(this.settings.getServerBaseURL()).append("/project/issues?id=").append(URLEncoder.encode(notification.getFieldValue("projectKey"), "UTF-8")).append("&issues=").append(issueKey).append("&open=").append(issueKey);
            String branchName = notification.getFieldValue("branch");
            if (branchName != null) {
                sb.append("&branch=").append(branchName);
            }
            if ((pullRequest = notification.getFieldValue("pullRequest")) != null) {
                sb.append("&pullRequest=").append(pullRequest);
            }
            sb.append('\n');
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }

    private static void appendLine(StringBuilder sb, @Nullable String line) {
        if (!Strings.isNullOrEmpty((String)line)) {
            sb.append(line).append('\n');
        }
    }

    private static void appendField(StringBuilder sb, String name, @Nullable String oldValue, @Nullable String newValue) {
        if (oldValue != null || newValue != null) {
            sb.append(name).append(": ");
            if (newValue != null) {
                sb.append(newValue);
            }
            if (oldValue != null) {
                sb.append(" (was ").append(oldValue).append(")");
            }
            sb.append('\n');
        }
    }

    private static void appendFieldWithoutHistory(StringBuilder sb, String name, @Nullable String oldValue, @Nullable String newValue) {
        if (oldValue != null || newValue != null) {
            sb.append(name);
            if (newValue != null) {
                sb.append(" changed to ");
                sb.append(newValue);
            } else {
                sb.append(" removed");
            }
            sb.append('\n');
        }
    }

    private String getUserFullName(@Nullable String login) {
        if (login == null) {
            return null;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto userDto = this.dbClient.userDao().selectByLogin(dbSession, login);
            if (userDto == null || !userDto.isActive()) {
                String string = login;
                return string;
            }
            String string = StringUtils.defaultIfBlank((String)userDto.getName(), (String)login);
            return string;
        }
    }
}

