/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;

public class ChangesOnMyIssueNotificationDispatcher
extends NotificationDispatcher {
    public static final String KEY = "ChangesOnMyIssue";
    private NotificationManager notificationManager;

    public ChangesOnMyIssueNotificationDispatcher(NotificationManager notificationManager) {
        super("issue-changes");
        this.notificationManager = notificationManager;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return NotificationDispatcherMetadata.create(KEY).setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    }

    @Override
    public void dispatch(Notification notification, NotificationDispatcher.Context context) {
        String assignee;
        String projectKey = notification.getFieldValue("projectKey");
        Multimap<String, NotificationChannel> subscribedRecipients = this.notificationManager.findSubscribedRecipientsForDispatcher(this, projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER);
        String changeAuthor = notification.getFieldValue("changeAuthor");
        if (!Objects.equals(changeAuthor, assignee = notification.getFieldValue("assignee"))) {
            ChangesOnMyIssueNotificationDispatcher.addUserToContextIfSubscribed(context, assignee, subscribedRecipients);
        }
    }

    private static void addUserToContextIfSubscribed(NotificationDispatcher.Context context, @Nullable String user, Multimap<String, NotificationChannel> subscribedRecipients) {
        if (user != null) {
            Collection channels = subscribedRecipients.get((Object)user);
            for (NotificationChannel channel : channels) {
                context.addUser(user, channel);
            }
        }
    }
}

