/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.metadata;

import java.util.Optional;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.index.get.GetField;
import org.sonar.server.es.DefaultIndexSettings;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.metadata.MetadataIndexDefinition;

public class MetadataIndex {
    private static final String DB_VENDOR_KEY = "dbVendor";
    private final EsClient esClient;

    public MetadataIndex(EsClient esClient) {
        this.esClient = esClient;
    }

    public Optional<String> getHash(String index) {
        return this.getMetadata(MetadataIndex.hashId(index));
    }

    public void setHash(String index, String hash) {
        this.setMetadata(MetadataIndex.hashId(index), hash);
    }

    private static String hashId(String index) {
        return index + ".indexStructure";
    }

    public boolean getInitialized(IndexType indexType) {
        return this.getMetadata(MetadataIndex.initializedId(indexType)).map(Boolean::parseBoolean).orElse(false);
    }

    public void setInitialized(IndexType indexType, boolean initialized) {
        this.setMetadata(MetadataIndex.initializedId(indexType), String.valueOf(initialized));
    }

    private static String initializedId(IndexType indexType) {
        return indexType.getIndex() + "." + indexType.getType() + ".initialized";
    }

    public Optional<String> getDbVendor() {
        return this.getMetadata(DB_VENDOR_KEY);
    }

    public void setDbMetadata(String vendor) {
        this.setMetadata(DB_VENDOR_KEY, vendor);
    }

    private Optional<String> getMetadata(String id) {
        GetRequestBuilder request = this.esClient.prepareGet(MetadataIndexDefinition.INDEX_TYPE_METADATA, id).setStoredFields(new String[]{"value"});
        GetResponse response = (GetResponse)request.get();
        if (response.isExists()) {
            GetField field = response.getField("value");
            String value = String.valueOf(field.getValue());
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private void setMetadata(String id, String value) {
        ((IndexRequestBuilder)this.esClient.prepareIndex(MetadataIndexDefinition.INDEX_TYPE_METADATA).setId(id).setSource(new Object[]{"value", value}).setRefreshPolicy(DefaultIndexSettings.REFRESH_IMMEDIATE)).get();
    }
}

