/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.List;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.ws.WsUtils;

public class Sorting {
    private final ListMultimap<String, Field> fields = ArrayListMultimap.create();
    private final List<Field> defaultFields = Lists.newArrayList();

    public Field add(String name) {
        Field field = new Field(name);
        this.fields.put((Object)name, (Object)field);
        return field;
    }

    public Field add(String name, String fieldName) {
        Field field = new Field(fieldName);
        this.fields.put((Object)name, (Object)field);
        return field;
    }

    public Field addDefault(String fieldName) {
        Field field = new Field(fieldName);
        this.defaultFields.add(field);
        return field;
    }

    public List<Field> getFields(String name) {
        return this.fields.get((Object)name);
    }

    public List<FieldSortBuilder> fill(String name, boolean asc) {
        List list = this.fields.get((Object)name);
        WsUtils.checkRequest(!list.isEmpty(), "Bad sort field: %s", name);
        return Sorting.doFill(list, asc);
    }

    public List<FieldSortBuilder> fillDefault() {
        return Sorting.doFill(this.defaultFields, true);
    }

    private static List<FieldSortBuilder> doFill(List<Field> fields, boolean asc) {
        return (List)fields.stream().map(field -> {
            FieldSortBuilder sortBuilder = SortBuilders.fieldSort((String)((Field)field).name);
            boolean effectiveAsc = asc != ((Field)field).reverse;
            sortBuilder.order(effectiveAsc ? SortOrder.ASC : SortOrder.DESC);
            boolean effectiveMissingLast = asc == ((Field)field).missingLast;
            sortBuilder.missing((Object)(effectiveMissingLast ? "_last" : "_first"));
            return sortBuilder;
        }).collect(MoreCollectors.toList((int)fields.size()));
    }

    public static class Field {
        private final String name;
        private boolean reverse = false;
        private boolean missingLast = false;

        public Field(String name) {
            this.name = name;
        }

        public Field missingLast() {
            this.missingLast = true;
            return this;
        }

        public Field reverse() {
            this.reverse = true;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public boolean isMissingLast() {
            return this.missingLast;
        }
    }
}

