/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;

public class ProjectIndexersImpl
implements ProjectIndexers {
    private final List<ProjectIndexer> indexers;

    public ProjectIndexersImpl(ProjectIndexer ... indexers) {
        this.indexers = Arrays.asList(indexers);
    }

    @Override
    public void commitAndIndexByProjectUuids(DbSession dbSession, Collection<String> projectUuids, ProjectIndexer.Cause cause) {
        IdentityHashMap<ProjectIndexer, Collection> itemsByIndexer = new IdentityHashMap<ProjectIndexer, Collection>();
        this.indexers.forEach(i -> itemsByIndexer.put((ProjectIndexer)i, i.prepareForRecovery(dbSession, projectUuids, cause)));
        dbSession.commit();
        itemsByIndexer.forEach((indexer, items) -> indexer.index(dbSession, (Collection<EsQueueDto>)items));
    }
}

