/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.ProgressLogger;
import org.sonar.server.es.DocId;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;

public class BulkIndexer {
    private static final Logger LOGGER = Loggers.get(BulkIndexer.class);
    private static final ByteSizeValue FLUSH_BYTE_SIZE = new ByteSizeValue(1L, ByteSizeUnit.MB);
    private static final int FLUSH_ACTIONS = -1;
    private static final String REFRESH_INTERVAL_SETTING = "index.refresh_interval";
    private static final int DEFAULT_NUMBER_OF_SHARDS = 5;
    private final EsClient client;
    private final IndexType indexType;
    private final BulkProcessor bulkProcessor;
    private final IndexingResult result = new IndexingResult();
    private final IndexingListener indexingListener;
    private final SizeHandler sizeHandler;

    public BulkIndexer(EsClient client, IndexType indexType, Size size) {
        this(client, indexType, size, IndexingListener.FAIL_ON_ERROR);
    }

    public BulkIndexer(EsClient client, IndexType indexType, Size size, IndexingListener indexingListener) {
        this.client = client;
        this.indexType = indexType;
        this.sizeHandler = size.createHandler(Runtime2.INSTANCE);
        this.indexingListener = indexingListener;
        BulkProcessorListener bulkProcessorListener = new BulkProcessorListener();
        this.bulkProcessor = BulkProcessor.builder((Client)client.nativeClient(), (BulkProcessor.Listener)bulkProcessorListener).setBackoffPolicy(BackoffPolicy.exponentialBackoff()).setBulkSize(FLUSH_BYTE_SIZE).setBulkActions(-1).setConcurrentRequests(this.sizeHandler.getConcurrentRequests()).build();
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void start() {
        this.result.clear();
        this.sizeHandler.beforeStart(this);
    }

    public IndexingResult stop() {
        try {
            this.bulkProcessor.awaitClose(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Elasticsearch bulk requests still being executed after 1 minute", e);
        }
        this.client.prepareRefresh(this.indexType.getIndex()).get();
        this.sizeHandler.afterStop(this);
        this.indexingListener.onFinish(this.result);
        return this.result;
    }

    public void add(IndexRequest request) {
        this.result.incrementRequests();
        this.bulkProcessor.add(request);
    }

    public void add(DeleteRequest request) {
        this.result.incrementRequests();
        this.bulkProcessor.add(request);
    }

    public void add(DocWriteRequest request) {
        this.result.incrementRequests();
        this.bulkProcessor.add(request);
    }

    public void addDeletion(SearchRequestBuilder searchRequest) {
        block3: {
            String scrollId;
            SearchHit[] hits;
            searchRequest.addSort("_doc", SortOrder.ASC).setScroll(TimeValue.timeValueMinutes((long)5L)).setSize(100).setFetchSource(false);
            SearchResponse searchResponse = (SearchResponse)searchRequest.get();
            do {
                for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
                    SearchHitField routing = hit.getField("_routing");
                    DeleteRequestBuilder deleteRequestBuilder = this.client.prepareDelete(hit.getIndex(), hit.getType(), hit.getId());
                    if (routing != null) {
                        deleteRequestBuilder.setRouting((String)routing.getValue());
                    }
                    this.add((DeleteRequest)deleteRequestBuilder.request());
                }
                scrollId = searchResponse.getScrollId();
                if (scrollId == null) break block3;
                searchResponse = (SearchResponse)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMinutes((long)5L)).get();
            } while (hits.length != 0);
            this.client.nativeClient().prepareClearScroll().addScrollId(scrollId).get();
        }
    }

    public void addDeletion(IndexType indexType, String id) {
        this.add((DeleteRequest)this.client.prepareDelete(indexType, id).request());
    }

    public void addDeletion(IndexType indexType, String id, @Nullable String routing) {
        this.add((DeleteRequest)this.client.prepareDelete(indexType, id).setRouting(routing).request());
    }

    public static IndexingResult delete(EsClient client, IndexType indexType, SearchRequestBuilder searchRequest) {
        BulkIndexer bulk = new BulkIndexer(client, indexType, Size.REGULAR);
        bulk.start();
        bulk.addDeletion(searchRequest);
        return bulk.stop();
    }

    static class LargeSizeHandler
    extends SizeHandler {
        private final Map<String, Object> initialSettings = new HashMap<String, Object>();
        private final Runtime2 runtime2;
        private ProgressLogger progress;

        LargeSizeHandler(Runtime2 runtime2) {
            this.runtime2 = runtime2;
        }

        @Override
        int getConcurrentRequests() {
            int cores = this.runtime2.getCores();
            return Math.max(1, cores / 5) - 1;
        }

        @Override
        void beforeStart(BulkIndexer bulkIndexer) {
            this.progress = new ProgressLogger(String.format("Progress[BulkIndexer[%s]]", bulkIndexer.indexType.getIndex()), ((BulkIndexer)bulkIndexer).result.total, LOGGER).setPluralLabel("requests");
            this.progress.start();
            HashMap<String, Object> temporarySettings = new HashMap<String, Object>();
            GetSettingsResponse settingsResp = (GetSettingsResponse)bulkIndexer.client.nativeClient().admin().indices().prepareGetSettings(new String[]{bulkIndexer.indexType.getIndex()}).get();
            int initialReplicas = Integer.parseInt(settingsResp.getSetting(bulkIndexer.indexType.getIndex(), "index.number_of_replicas"));
            if (initialReplicas > 0) {
                this.initialSettings.put("index.number_of_replicas", initialReplicas);
                temporarySettings.put("index.number_of_replicas", 0);
            }
            String refreshInterval = settingsResp.getSetting(bulkIndexer.indexType.getIndex(), BulkIndexer.REFRESH_INTERVAL_SETTING);
            this.initialSettings.put(BulkIndexer.REFRESH_INTERVAL_SETTING, refreshInterval);
            temporarySettings.put(BulkIndexer.REFRESH_INTERVAL_SETTING, "-1");
            LargeSizeHandler.updateSettings(bulkIndexer, temporarySettings);
        }

        @Override
        void afterStop(BulkIndexer bulkIndexer) {
            bulkIndexer.client.prepareForceMerge(bulkIndexer.indexType.getIndex()).get();
            LargeSizeHandler.updateSettings(bulkIndexer, this.initialSettings);
            this.progress.stop();
        }

        private static void updateSettings(BulkIndexer bulkIndexer, Map<String, Object> settings) {
            UpdateSettingsRequestBuilder req = bulkIndexer.client.nativeClient().admin().indices().prepareUpdateSettings(new String[]{bulkIndexer.indexType.getIndex()});
            req.setSettings(settings);
            req.get();
        }
    }

    static class SizeHandler {
        SizeHandler() {
        }

        int getConcurrentRequests() {
            return 0;
        }

        void beforeStart(BulkIndexer bulkIndexer) {
        }

        void afterStop(BulkIndexer bulkIndexer) {
        }
    }

    @VisibleForTesting
    static class Runtime2 {
        private static final Runtime2 INSTANCE = new Runtime2();

        Runtime2() {
        }

        int getCores() {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public static enum Size {
        REGULAR{

            @Override
            SizeHandler createHandler(Runtime2 runtime2) {
                return new SizeHandler();
            }
        }
        ,
        LARGE{

            @Override
            SizeHandler createHandler(Runtime2 runtime2) {
                return new LargeSizeHandler(runtime2);
            }
        };


        abstract SizeHandler createHandler(Runtime2 var1);
    }

    private static class BulkRequestKey {
        private String requestType;
        private String index;
        private String docType;

        private BulkRequestKey(String requestType, String index, String docType) {
            this.requestType = requestType;
            this.index = index;
            this.docType = docType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BulkRequestKey that = (BulkRequestKey)o;
            if (!this.docType.equals(that.docType)) {
                return false;
            }
            if (!this.index.equals(that.index)) {
                return false;
            }
            return this.requestType.equals(that.requestType);
        }

        public int hashCode() {
            int result = this.requestType.hashCode();
            result = 31 * result + this.index.hashCode();
            result = 31 * result + this.docType.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s requests on %s/%s", this.requestType, this.index, this.docType);
        }
    }

    private final class BulkProcessorListener
    implements BulkProcessor.Listener {
        private final Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER);

        private BulkProcessorListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request) {
            this.profiler.start();
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            this.stopProfiler(request);
            ArrayList<DocId> successDocIds = new ArrayList<DocId>();
            for (BulkItemResponse item : response.getItems()) {
                if (item.isFailed()) {
                    LOGGER.error("index [{}], type [{}], id [{}], message [{}]", new Object[]{item.getIndex(), item.getType(), item.getId(), item.getFailureMessage()});
                    continue;
                }
                BulkIndexer.this.result.incrementSuccess();
                successDocIds.add(new DocId(item.getIndex(), item.getType(), item.getId()));
            }
            BulkIndexer.this.indexingListener.onSuccess(successDocIds);
        }

        public void afterBulk(long executionId, BulkRequest request, Throwable e) {
            LOGGER.error("Fail to execute bulk index request: " + request, e);
            this.stopProfiler(request);
        }

        private void stopProfiler(BulkRequest request) {
            if (this.profiler.isTraceEnabled()) {
                this.profiler.stopTrace(this.toString(request));
            }
        }

        private String toString(BulkRequest bulkRequest) {
            StringBuilder message = new StringBuilder();
            message.append("Bulk[");
            LinkedHashMultiset groupedRequests = LinkedHashMultiset.create();
            for (int i = 0; i < bulkRequest.requests().size(); ++i) {
                String requestType;
                DocWriteRequest item = (DocWriteRequest)bulkRequest.requests().get(i);
                if (item instanceof IndexRequest) {
                    requestType = "index";
                } else if (item instanceof UpdateRequest) {
                    requestType = "update";
                } else if (item instanceof DeleteRequest) {
                    requestType = "delete";
                } else {
                    throw new IllegalStateException("Unsupported bulk request type: " + item.getClass());
                }
                groupedRequests.add((Object)new BulkRequestKey(requestType, item.index(), item.type()));
            }
            Set entrySet = groupedRequests.entrySet();
            int size = entrySet.size();
            int current = 0;
            for (Multiset.Entry requestEntry : entrySet) {
                message.append(requestEntry.getCount()).append(" ").append(((BulkRequestKey)requestEntry.getElement()).toString());
                if (++current >= size) continue;
                message.append(", ");
            }
            message.append("]");
            return message.toString();
        }
    }
}

