/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.event.EventDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.event.Event;
import org.sonar.server.computation.task.projectanalysis.event.EventRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistEventsStep
implements ComputationStep {
    private final DbClient dbClient;
    private final System2 system2;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder treeRootHolder;
    private final EventRepository eventRepository;
    private final UuidFactory uuidFactory;

    public PersistEventsStep(DbClient dbClient, System2 system2, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, EventRepository eventRepository, UuidFactory uuidFactory) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.eventRepository = eventRepository;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            long analysisDate = this.analysisMetadataHolder.getAnalysisDate();
            new DepthTraversalTypeAwareCrawler(new PersistEventComponentVisitor(dbSession, analysisDate)).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Persist events";
    }

    private class PersistEventComponentVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private final long analysisDate;

        PersistEventComponentVisitor(DbSession session, long analysisDate) {
            super(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.PRE_ORDER);
            this.session = session;
            this.analysisDate = analysisDate;
        }

        @Override
        public void visitProject(Component project) {
            this.processEvents(this.session, project, this.analysisDate);
            this.saveVersionEvent(this.session, project, this.analysisDate);
        }

        private void processEvents(DbSession session, Component component, Long analysisDate) {
            Function<Event, EventDto> eventToEventDto = event -> this.newBaseEvent(component, analysisDate).setName(event.getName()).setCategory(this.convertCategory(event.getCategory())).setDescription(event.getDescription()).setData(event.getData());
            for (EventDto batchEventDto : StreamSupport.stream(PersistEventsStep.this.eventRepository.getEvents(component).spliterator(), false).map(eventToEventDto).collect(Collectors.toList())) {
                PersistEventsStep.this.dbClient.eventDao().insert(session, batchEventDto);
            }
        }

        private void saveVersionEvent(DbSession session, Component component, Long analysisDate) {
            String version = component.getReportAttributes().getVersion();
            if (version != null) {
                this.deletePreviousEventsHavingSameVersion(session, version, component);
                PersistEventsStep.this.dbClient.eventDao().insert(session, this.newBaseEvent(component, analysisDate).setName(version).setCategory("Version"));
            }
        }

        private void deletePreviousEventsHavingSameVersion(DbSession session, String version, Component component) {
            for (EventDto dto : PersistEventsStep.this.dbClient.eventDao().selectByComponentUuid(session, component.getUuid())) {
                if (!Objects.equals(dto.getCategory(), "Version") || !Objects.equals(dto.getName(), version)) continue;
                PersistEventsStep.this.dbClient.eventDao().delete(session, dto.getId());
            }
        }

        private EventDto newBaseEvent(Component component, Long analysisDate) {
            return new EventDto().setUuid(PersistEventsStep.this.uuidFactory.create()).setAnalysisUuid(PersistEventsStep.this.analysisMetadataHolder.getUuid()).setComponentUuid(component.getUuid()).setCreatedAt(Long.valueOf(PersistEventsStep.this.system2.now())).setDate(analysisDate);
        }

        private String convertCategory(Event.Category category) {
            switch (category) {
                case ALERT: {
                    return "Alert";
                }
                case PROFILE: {
                    return "Profile";
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported category %s", category.name()));
        }
    }
}

