/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.duplication.DuplicationUnitDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.duplication.CrossProjectDuplicationStatusHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class PersistCrossProjectDuplicationIndexStep
implements ComputationStep {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final BatchReportReader reportReader;
    private final CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder;

    public PersistCrossProjectDuplicationIndexStep(CrossProjectDuplicationStatusHolder crossProjectDuplicationStatusHolder, DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder, BatchReportReader reportReader) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.reportReader = reportReader;
        this.crossProjectDuplicationStatusHolder = crossProjectDuplicationStatusHolder;
    }

    @Override
    public void execute() {
        if (!this.crossProjectDuplicationStatusHolder.isEnabled()) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(true);){
            Component project = this.treeRootHolder.getRoot();
            new DepthTraversalTypeAwareCrawler(new DuplicationVisitor(dbSession, this.analysisMetadataHolder.getUuid())).visit(project);
            dbSession.commit();
        }
    }

    @Override
    public String getDescription() {
        return "Persist cross project duplications index";
    }

    private class DuplicationVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private final String analysisUuid;

        private DuplicationVisitor(DbSession session, String analysisUuid) {
            super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.PRE_ORDER);
            this.session = session;
            this.analysisUuid = analysisUuid;
        }

        @Override
        public void visitFile(Component file) {
            this.visitComponent(file);
        }

        private void visitComponent(Component component) {
            this.readFromReport(component);
        }

        private void readFromReport(Component component) {
            int indexInFile = 0;
            try (CloseableIterator<ScannerReport.CpdTextBlock> blocks = PersistCrossProjectDuplicationIndexStep.this.reportReader.readCpdTextBlocks(component.getReportAttributes().getRef());){
                while (blocks.hasNext()) {
                    ScannerReport.CpdTextBlock block = (ScannerReport.CpdTextBlock)blocks.next();
                    PersistCrossProjectDuplicationIndexStep.this.dbClient.duplicationDao().insert(this.session, new DuplicationUnitDto().setHash(block.getHash()).setStartLine(block.getStartLine()).setEndLine(block.getEndLine()).setIndexInFile(indexInFile).setAnalysisUuid(this.analysisUuid).setComponentUuid(component.getUuid()));
                    ++indexInFile;
                }
            }
        }
    }
}

