/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.component.SnapshotQuery;
import org.sonar.server.computation.task.projectanalysis.period.Period;

public class PeriodResolver {
    private static final Logger LOG = Loggers.get(PeriodResolver.class);
    private final DbClient dbClient;
    private final DbSession session;
    private final String projectUuid;
    private final long analysisDate;
    @CheckForNull
    private final String currentVersion;

    public PeriodResolver(DbClient dbClient, DbSession session, String projectUuid, long analysisDate, @Nullable String currentVersion) {
        this.dbClient = dbClient;
        this.session = session;
        this.projectUuid = projectUuid;
        this.analysisDate = analysisDate;
        this.currentVersion = currentVersion;
    }

    @CheckForNull
    public Period resolve(Configuration config) {
        String propertyValue = PeriodResolver.getPropertyValue(config);
        if (StringUtils.isBlank((String)propertyValue)) {
            return null;
        }
        Period period = this.resolve(propertyValue);
        if (period == null && StringUtils.isNotBlank((String)propertyValue)) {
            LOG.debug("Property sonar.leak.period is not valid: " + propertyValue);
        }
        return period;
    }

    @CheckForNull
    private Period resolve(String property) {
        Integer days = PeriodResolver.tryToResolveByDays(property);
        if (days != null) {
            return this.findByDays(days);
        }
        Date date = DateUtils.parseDateQuietly((String)property);
        if (date != null) {
            return this.findByDate(date);
        }
        if (StringUtils.equals((String)"previous_version", (String)property)) {
            return this.findByPreviousVersion();
        }
        return this.findByVersion(property);
    }

    private Period findByDate(Date date) {
        SnapshotDto snapshot = this.findFirstSnapshot(this.session, PeriodResolver.createCommonQuery(this.projectUuid).setCreatedAfter(Long.valueOf(date.getTime())).setSort(SnapshotQuery.SORT_FIELD.BY_DATE, SnapshotQuery.SORT_ORDER.ASC));
        if (snapshot == null) {
            return null;
        }
        LOG.debug("Compare to date {} (analysis of {})", (Object)PeriodResolver.formatDate(date.getTime()), (Object)PeriodResolver.formatDate(snapshot.getCreatedAt()));
        return new Period("date", DateUtils.formatDate((Date)date), snapshot.getCreatedAt(), snapshot.getUuid());
    }

    @CheckForNull
    private Period findByDays(int days) {
        long targetDate;
        List snapshots = this.dbClient.snapshotDao().selectAnalysesByQuery(this.session, PeriodResolver.createCommonQuery(this.projectUuid).setCreatedBefore(Long.valueOf(this.analysisDate)).setSort(SnapshotQuery.SORT_FIELD.BY_DATE, SnapshotQuery.SORT_ORDER.ASC));
        SnapshotDto snapshot = PeriodResolver.findNearestSnapshotToTargetDate(snapshots, targetDate = DateUtils.addDays((Date)new Date(this.analysisDate), (int)(-days)).getTime());
        if (snapshot == null) {
            return null;
        }
        LOG.debug("Compare over {} days ({}, analysis of {})", new Object[]{String.valueOf(days), PeriodResolver.formatDate(targetDate), PeriodResolver.formatDate(snapshot.getCreatedAt())});
        return new Period("days", String.valueOf(days), snapshot.getCreatedAt(), snapshot.getUuid());
    }

    @CheckForNull
    private Period findByPreviousVersion() {
        if (this.currentVersion == null) {
            return null;
        }
        List snapshotDtos = this.dbClient.snapshotDao().selectPreviousVersionSnapshots(this.session, this.projectUuid, this.currentVersion);
        if (snapshotDtos.isEmpty()) {
            return this.findByFirstAnalysis();
        }
        SnapshotDto snapshotDto = (SnapshotDto)snapshotDtos.get(0);
        LOG.debug("Compare to previous version ({})", (Object)PeriodResolver.formatDate(snapshotDto.getCreatedAt()));
        return new Period("previous_version", snapshotDto.getVersion(), snapshotDto.getCreatedAt(), snapshotDto.getUuid());
    }

    @CheckForNull
    private Period findByFirstAnalysis() {
        SnapshotDto snapshotDto = this.dbClient.snapshotDao().selectOldestSnapshot(this.session, this.projectUuid);
        if (snapshotDto == null) {
            return null;
        }
        LOG.debug("Compare to first analysis ({})", (Object)PeriodResolver.formatDate(snapshotDto.getCreatedAt()));
        return new Period("previous_version", null, snapshotDto.getCreatedAt(), snapshotDto.getUuid());
    }

    @CheckForNull
    private Period findByVersion(String version) {
        SnapshotDto snapshot = this.findFirstSnapshot(this.session, PeriodResolver.createCommonQuery(this.projectUuid).setVersion(version).setSort(SnapshotQuery.SORT_FIELD.BY_DATE, SnapshotQuery.SORT_ORDER.DESC));
        if (snapshot == null) {
            return null;
        }
        LOG.debug("Compare to version ({}) ({})", (Object)version, (Object)PeriodResolver.formatDate(snapshot.getCreatedAt()));
        return new Period("version", version, snapshot.getCreatedAt(), snapshot.getUuid());
    }

    @CheckForNull
    private SnapshotDto findFirstSnapshot(DbSession session, SnapshotQuery query) {
        List snapshots = this.dbClient.snapshotDao().selectAnalysesByQuery(session, query);
        if (!snapshots.isEmpty()) {
            return (SnapshotDto)snapshots.get(0);
        }
        return null;
    }

    @CheckForNull
    private static Integer tryToResolveByDays(String property) {
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @CheckForNull
    private static SnapshotDto findNearestSnapshotToTargetDate(List<SnapshotDto> snapshots, Long targetDate) {
        long bestDistance = Long.MAX_VALUE;
        SnapshotDto nearest = null;
        for (SnapshotDto snapshot : snapshots) {
            long distance = Math.abs(snapshot.getCreatedAt() - targetDate);
            if (distance > bestDistance) continue;
            bestDistance = distance;
            nearest = snapshot;
        }
        return nearest;
    }

    private static SnapshotQuery createCommonQuery(String projectUuid) {
        return new SnapshotQuery().setComponentUuid(projectUuid).setStatus("P");
    }

    private static String formatDate(long date) {
        return DateUtils.formatDate((Date)Date.from(new Date(date).toInstant().truncatedTo(ChronoUnit.SECONDS)));
    }

    private static String getPropertyValue(Configuration config) {
        return (String)config.get("sonar.leak.period").get();
    }
}

