/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;
import org.sonar.server.computation.task.projectanalysis.qualitygate.MutableQualityGateHolder;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGate;
import org.sonar.server.computation.task.projectanalysis.qualitygate.QualityGateService;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadQualityGateStep
implements ComputationStep {
    private static final String PROPERTY_PROJECT_QUALITY_GATE = "sonar.qualitygate";
    private final ConfigurationRepository configRepository;
    private final QualityGateService qualityGateService;
    private final MutableQualityGateHolder qualityGateHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public LoadQualityGateStep(ConfigurationRepository settingsRepository, QualityGateService qualityGateService, MutableQualityGateHolder qualityGateHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.configRepository = settingsRepository;
        this.qualityGateService = qualityGateService;
        this.qualityGateHolder = qualityGateHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void execute() {
        Optional<QualityGate> qualityGate = this.getShortLivingBranchQualityGate();
        if (!qualityGate.isPresent() && !(qualityGate = this.getProjectQualityGate()).isPresent()) {
            qualityGate = Optional.of(this.getOrganizationDefaultQualityGate());
        }
        this.qualityGateHolder.setQualityGate(qualityGate.orElseThrow(() -> new IllegalStateException("Quality gate not present")));
    }

    private Optional<QualityGate> getShortLivingBranchQualityGate() {
        if (this.analysisMetadataHolder.isShortLivingBranch() || this.analysisMetadataHolder.isPullRequest()) {
            Optional<QualityGate> qualityGate = this.qualityGateService.findById(-1963456987L);
            if (qualityGate.isPresent()) {
                return qualityGate;
            }
            throw new IllegalStateException("Failed to retrieve hardcoded short living branch Quality Gate");
        }
        return Optional.empty();
    }

    private Optional<QualityGate> getProjectQualityGate() {
        Configuration config = this.configRepository.getConfiguration();
        String qualityGateSetting = config.get(PROPERTY_PROJECT_QUALITY_GATE).orElse(null);
        if (StringUtils.isBlank((String)qualityGateSetting)) {
            return Optional.empty();
        }
        try {
            long qualityGateId = Long.parseLong(qualityGateSetting);
            return this.qualityGateService.findById(qualityGateId);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Unsupported value (%s) in property %s", qualityGateSetting, PROPERTY_PROJECT_QUALITY_GATE), e);
        }
    }

    private QualityGate getOrganizationDefaultQualityGate() {
        return this.qualityGateService.findDefaultQualityGate(this.analysisMetadataHolder.getOrganization());
    }

    @Override
    public String getDescription() {
        return "Load Quality gate";
    }
}

