/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.formula.SumFormula;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredFormula;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.LinesAndConditionsWithUncoveredMetricKeys;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.SingleWithUncoveredFormula;
import org.sonar.server.computation.task.projectanalysis.formula.coverage.SingleWithUncoveredMetricKeys;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class CoverageMeasuresStep
implements ComputationStep {
    private static final ImmutableList<Formula> COVERAGE_FORMULAS = ImmutableList.of((Object)SumFormula.createIntSumFormula("lines_to_cover"), (Object)SumFormula.createIntSumFormula("uncovered_lines"), (Object)SumFormula.createIntSumFormula("conditions_to_cover"), (Object)SumFormula.createIntSumFormula("uncovered_conditions"), (Object)new CodeCoverageFormula(), (Object)new BranchCoverageFormula(), (Object)new LineCoverageFormula());
    private final TreeRootHolder treeRootHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;

    public CoverageMeasuresStep(TreeRootHolder treeRootHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.treeRootHolder = treeRootHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).buildFor((Iterable<Formula>)COVERAGE_FORMULAS)).visit(this.treeRootHolder.getRoot());
    }

    @Override
    public String getDescription() {
        return "Compute coverage measures";
    }

    private static class LineCoverageFormula
    extends SingleWithUncoveredFormula {
        public LineCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("lines_to_cover", "uncovered_lines"), "line_coverage");
        }
    }

    private static class BranchCoverageFormula
    extends SingleWithUncoveredFormula {
        public BranchCoverageFormula() {
            super(new SingleWithUncoveredMetricKeys("conditions_to_cover", "uncovered_conditions"), "branch_coverage");
        }
    }

    private static class CodeCoverageFormula
    extends LinesAndConditionsWithUncoveredFormula {
        public CodeCoverageFormula() {
            super(new LinesAndConditionsWithUncoveredMetricKeys("lines_to_cover", "conditions_to_cover", "uncovered_lines", "uncovered_conditions"), "coverage");
        }
    }
}

