/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.component.SnapshotQuery;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.analysis.Analysis;
import org.sonar.server.computation.task.projectanalysis.analysis.Branch;
import org.sonar.server.computation.task.projectanalysis.analysis.MutableAnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentKeyGenerator;
import org.sonar.server.computation.task.projectanalysis.component.ComponentTreeBuilder;
import org.sonar.server.computation.task.projectanalysis.component.ComponentUuidFactory;
import org.sonar.server.computation.task.projectanalysis.component.DefaultBranchImpl;
import org.sonar.server.computation.task.projectanalysis.component.MutableTreeRootHolder;
import org.sonar.server.computation.task.step.ComputationStep;

public class BuildComponentTreeStep
implements ComputationStep {
    private final DbClient dbClient;
    private final BatchReportReader reportReader;
    private final MutableTreeRootHolder treeRootHolder;
    private final MutableAnalysisMetadataHolder analysisMetadataHolder;

    public BuildComponentTreeStep(DbClient dbClient, BatchReportReader reportReader, MutableTreeRootHolder treeRootHolder, MutableAnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.reportReader = reportReader;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public String getDescription() {
        return "Build tree of components";
    }

    @Override
    public void execute() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ScannerReport.Component reportProject = this.reportReader.readComponent(this.analysisMetadataHolder.getRootComponentRef());
            ComponentKeyGenerator keyGenerator = this.loadKeyGenerator();
            ComponentKeyGenerator publicKeyGenerator = this.loadPublicKeyGenerator();
            String rootKey = keyGenerator.generateKey(reportProject, null);
            ComponentUuidFactory componentUuidFactory = new ComponentUuidFactory(this.dbClient, dbSession, rootKey);
            String rootUuid = componentUuidFactory.getOrCreateForKey(rootKey);
            SnapshotDto baseAnalysis = this.loadBaseAnalysis(dbSession, rootUuid);
            ComponentTreeBuilder builder = new ComponentTreeBuilder(keyGenerator, publicKeyGenerator, componentUuidFactory::getOrCreateForKey, this.reportReader::readComponent, this.analysisMetadataHolder.getProject(), this.analysisMetadataHolder.getBranch(), baseAnalysis);
            String relativePathFromScmRoot = this.reportReader.readMetadata().getRelativePathFromScmRoot();
            Component project = builder.buildProject(reportProject, relativePathFromScmRoot);
            this.treeRootHolder.setRoot(project);
            this.analysisMetadataHolder.setBaseAnalysis(BuildComponentTreeStep.toAnalysis(baseAnalysis));
        }
    }

    private ComponentKeyGenerator loadKeyGenerator() {
        return this.analysisMetadataHolder.getBranch();
    }

    private ComponentKeyGenerator loadPublicKeyGenerator() {
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (!branch.isLegacyFeature() && !branch.isMain()) {
            return new DefaultBranchImpl();
        }
        return branch;
    }

    @CheckForNull
    private SnapshotDto loadBaseAnalysis(DbSession dbSession, String rootUuid) {
        return this.dbClient.snapshotDao().selectAnalysisByQuery(dbSession, new SnapshotQuery().setComponentUuid(rootUuid).setIsLast(Boolean.valueOf(true)));
    }

    @CheckForNull
    private static Analysis toAnalysis(@Nullable SnapshotDto dto) {
        if (dto != null) {
            return new Analysis.Builder().setId(dto.getId()).setUuid(dto.getUuid()).setCreatedAt(dto.getCreatedAt()).build();
        }
        return null;
    }
}

