/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source.linereader;

import javax.annotation.CheckForNull;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.source.linereader.LineReader;

public class ScmLineReader
implements LineReader {
    private final ScmInfo scmReport;
    @CheckForNull
    private Changeset latestChange;
    @CheckForNull
    private Changeset latestChangeWithRevision;

    public ScmLineReader(ScmInfo scmReport) {
        this.scmReport = scmReport;
    }

    @Override
    public void read(DbFileSources.Line.Builder lineBuilder) {
        if (this.scmReport.hasChangesetForLine(lineBuilder.getLine())) {
            String revision;
            Changeset changeset = this.scmReport.getChangesetForLine(lineBuilder.getLine());
            String author = changeset.getAuthor();
            if (author != null) {
                lineBuilder.setScmAuthor(author);
            }
            if ((revision = changeset.getRevision()) != null) {
                lineBuilder.setScmRevision(revision);
            }
            lineBuilder.setScmDate(changeset.getDate());
            this.updateLatestChange(changeset);
            if (revision != null) {
                this.updateLatestChangeWithRevision(changeset);
            }
        }
    }

    private void updateLatestChange(Changeset newChangeSet) {
        if (this.latestChange == null) {
            this.latestChange = newChangeSet;
        } else {
            long latestChangeDate;
            long newChangesetDate = newChangeSet.getDate();
            if (newChangesetDate > (latestChangeDate = this.latestChange.getDate())) {
                this.latestChange = newChangeSet;
            }
        }
    }

    private void updateLatestChangeWithRevision(Changeset newChangeSet) {
        if (this.latestChangeWithRevision == null) {
            this.latestChangeWithRevision = newChangeSet;
        } else {
            long latestChangeDate;
            long newChangesetDate = newChangeSet.getDate();
            if (newChangesetDate > (latestChangeDate = this.latestChangeWithRevision.getDate())) {
                this.latestChangeWithRevision = newChangeSet;
            }
        }
    }

    @CheckForNull
    public Changeset getLatestChangeWithRevision() {
        return this.latestChangeWithRevision;
    }

    @CheckForNull
    public Changeset getLatestChange() {
        return this.latestChange;
    }
}

