/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import difflib.myers.DifferentiationFailedException;
import difflib.myers.MyersDiff;
import difflib.myers.PathNode;
import java.util.List;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class SourceLinesDiffFinder {
    private static final Logger LOG = Loggers.get(SourceLinesDiffFinder.class);

    public int[] findMatchingLines(List<String> left, List<String> right) {
        int[] index = new int[right.size()];
        int dbLine = left.size();
        int reportLine = right.size();
        try {
            PathNode node = MyersDiff.buildPath((Object[])left.toArray(), (Object[])right.toArray());
            while (node.prev != null) {
                PathNode prevNode = node.prev;
                if (!node.isSnake()) {
                    reportLine -= node.j - prevNode.j;
                    dbLine -= node.i - prevNode.i;
                } else {
                    for (int i = node.i; i > prevNode.i; --i) {
                        index[reportLine - 1] = dbLine--;
                        --reportLine;
                    }
                }
                node = prevNode;
            }
        }
        catch (DifferentiationFailedException e) {
            LOG.error("Error finding matching lines", (Throwable)e);
            return index;
        }
        return index;
    }
}

