/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.source;

import java.util.HashMap;
import java.util.Map;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.LineHashVersion;
import org.sonar.server.computation.task.projectanalysis.component.Component;

public class DbLineHashVersion {
    private final Map<Component, LineHashVersion> lineHashVersionPerComponent = new HashMap<Component, LineHashVersion>();
    private final DbClient dbClient;

    public DbLineHashVersion(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public boolean hasLineHashesWithSignificantCode(Component component) {
        return this.lineHashVersionPerComponent.computeIfAbsent(component, this::compute) == LineHashVersion.WITH_SIGNIFICANT_CODE;
    }

    private LineHashVersion compute(Component component) {
        try (DbSession session = this.dbClient.openSession(false);){
            LineHashVersion lineHashVersion = this.dbClient.fileSourceDao().selectLineHashesVersion(session, component.getUuid());
            return lineHashVersion;
        }
    }
}

