/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;

@Immutable
public class ScmInfoImpl
implements ScmInfo {
    private final Changeset latestChangeset;
    private final Map<Integer, Changeset> lineChangesets;

    public ScmInfoImpl(Map<Integer, Changeset> lineChangesets) {
        Preconditions.checkState((!lineChangesets.isEmpty() ? 1 : 0) != 0, (Object)"A ScmInfo must have at least one Changeset and does not support any null one");
        this.lineChangesets = Collections.unmodifiableMap(lineChangesets);
        this.latestChangeset = ScmInfoImpl.computeLatestChangeset(lineChangesets);
    }

    private static Changeset computeLatestChangeset(Map<Integer, Changeset> lineChangesets) {
        return lineChangesets.values().stream().max(Comparator.comparingLong(Changeset::getDate)).orElseThrow(() -> new IllegalStateException("Expecting at least one Changeset to be present"));
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.latestChangeset;
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        Changeset changeset = this.lineChangesets.get(lineNumber);
        if (changeset != null) {
            return changeset;
        }
        throw new IllegalArgumentException("There's no changeset on line " + lineNumber);
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return this.lineChangesets.containsKey(lineNumber);
    }

    @Override
    public Map<Integer, Changeset> getAllChangesets() {
        return this.lineChangesets;
    }

    public String toString() {
        return "ScmInfoImpl{latestChangeset=" + this.latestChangeset + ", lineChangesets=" + this.lineChangesets + '}';
    }
}

