/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitymodel;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;

public enum Rating {
    E(5),
    D(4),
    C(3),
    B(2),
    A(1);

    private final int index;
    public static final Map<String, Rating> RATING_BY_SEVERITY;

    private Rating(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public static Rating valueOf(int index) {
        return Arrays.stream(Rating.values()).filter(r -> r.getIndex() == index).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown value '%s'", index)));
    }

    static {
        RATING_BY_SEVERITY = ImmutableMap.of((Object)"BLOCKER", (Object)((Object)E), (Object)"CRITICAL", (Object)((Object)D), (Object)"MAJOR", (Object)((Object)C), (Object)"MINOR", (Object)((Object)B), (Object)"INFO", (Object)((Object)A));
    }
}

