/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitymodel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitor;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.formula.counter.RatingValue;
import org.sonar.server.computation.task.projectanalysis.issue.ComponentIssuesRepository;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.Rating;

public class NewReliabilityAndSecurityRatingMeasuresVisitor
extends PathAwareVisitorAdapter<Counter> {
    private static final Map<String, Rating> RATING_BY_SEVERITY = ImmutableMap.of((Object)"BLOCKER", (Object)((Object)Rating.E), (Object)"CRITICAL", (Object)((Object)Rating.D), (Object)"MAJOR", (Object)((Object)Rating.C), (Object)"MINOR", (Object)((Object)Rating.B), (Object)"INFO", (Object)((Object)Rating.A));
    private final MeasureRepository measureRepository;
    private final ComponentIssuesRepository componentIssuesRepository;
    private final PeriodHolder periodHolder;
    private final Map<String, Metric> metricsByKey;

    public NewReliabilityAndSecurityRatingMeasuresVisitor(MetricRepository metricRepository, MeasureRepository measureRepository, ComponentIssuesRepository componentIssuesRepository, PeriodHolder periodHolder) {
        super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.POST_ORDER, CounterFactory.INSTANCE);
        this.measureRepository = measureRepository;
        this.componentIssuesRepository = componentIssuesRepository;
        this.periodHolder = periodHolder;
        this.metricsByKey = ImmutableMap.of((Object)"new_reliability_rating", (Object)metricRepository.getByKey("new_reliability_rating"), (Object)"new_security_rating", (Object)metricRepository.getByKey("new_security_rating"));
    }

    @Override
    public void visitProject(Component project, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(project, path);
    }

    @Override
    public void visitDirectory(Component directory, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(directory, path);
    }

    @Override
    public void visitModule(Component module, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(module, path);
    }

    @Override
    public void visitFile(Component file, PathAwareVisitor.Path<Counter> path) {
        this.computeAndSaveMeasures(file, path);
    }

    private void computeAndSaveMeasures(Component component, PathAwareVisitor.Path<Counter> path) {
        if (!this.periodHolder.hasPeriod()) {
            return;
        }
        NewReliabilityAndSecurityRatingMeasuresVisitor.initRatingsToA(path);
        this.processIssues(component, path);
        path.current().newRatingValueByMetric.entrySet().stream().filter(entry -> ((RatingValue)entry.getValue()).isSet()).forEach(entry -> this.measureRepository.add(component, this.metricsByKey.get(entry.getKey()), Measure.newMeasureBuilder().setVariation(((RatingValue)entry.getValue()).getValue().getIndex()).createNoValue()));
        NewReliabilityAndSecurityRatingMeasuresVisitor.addToParent(path);
    }

    private static void initRatingsToA(PathAwareVisitor.Path<Counter> path) {
        path.current().newRatingValueByMetric.values().forEach(entry -> entry.increment(Rating.A));
    }

    private void processIssues(Component component, PathAwareVisitor.Path<Counter> path) {
        this.componentIssuesRepository.getIssues(component).stream().filter(issue -> issue.resolution() == null).filter(issue -> issue.type().equals((Object)RuleType.BUG) || issue.type().equals((Object)RuleType.VULNERABILITY)).forEach(issue -> ((Counter)path.current()).processIssue((Issue)issue, this.periodHolder.getPeriod()));
    }

    private static void addToParent(PathAwareVisitor.Path<Counter> path) {
        if (!path.isRoot()) {
            path.parent().add(path.current());
        }
    }

    private static final class CounterFactory
    extends PathAwareVisitorAdapter.SimpleStackElementFactory<Counter> {
        public static final CounterFactory INSTANCE = new CounterFactory();

        private CounterFactory() {
        }

        @Override
        public Counter createForAny(Component component) {
            return new Counter();
        }
    }

    static final class Counter {
        private Map<String, RatingValue> newRatingValueByMetric = ImmutableMap.of((Object)"new_reliability_rating", (Object)new RatingValue(), (Object)"new_security_rating", (Object)new RatingValue());

        private Counter() {
        }

        void add(Counter otherCounter) {
            this.newRatingValueByMetric.entrySet().forEach(e -> ((RatingValue)e.getValue()).increment(otherCounter.newRatingValueByMetric.get(e.getKey())));
        }

        void processIssue(Issue issue, Period period) {
            if (Counter.isOnPeriod((DefaultIssue)issue, period)) {
                Rating rating = (Rating)((Object)RATING_BY_SEVERITY.get(issue.severity()));
                if (issue.type().equals((Object)RuleType.BUG)) {
                    this.newRatingValueByMetric.get("new_reliability_rating").increment(rating);
                } else if (issue.type().equals((Object)RuleType.VULNERABILITY)) {
                    this.newRatingValueByMetric.get("new_security_rating").increment(rating);
                }
            }
        }

        private static boolean isOnPeriod(DefaultIssue issue, Period period) {
            return issue.creationDate().getTime() > DateUtils.truncateToSeconds((long)period.getSnapshotDate());
        }
    }
}

