/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.measure;

import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.MeasureDto;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentFunctions;
import org.sonar.server.computation.task.projectanalysis.measure.BatchMeasureToMeasure;
import org.sonar.server.computation.task.projectanalysis.measure.MapBasedRawMeasureRepository;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureDtoToMeasure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.metric.ReportMetricValidator;

public class MeasureRepositoryImpl
implements MeasureRepository {
    private final MapBasedRawMeasureRepository<Integer> delegate = new MapBasedRawMeasureRepository<Integer>(ComponentFunctions.toReportRef());
    private final DbClient dbClient;
    private final BatchReportReader reportReader;
    private final BatchMeasureToMeasure batchMeasureToMeasure;
    private final MetricRepository metricRepository;
    private final ReportMetricValidator reportMetricValidator;
    private MeasureDtoToMeasure measureTransformer = new MeasureDtoToMeasure();
    private final Set<Integer> loadedComponents = new HashSet<Integer>();

    public MeasureRepositoryImpl(DbClient dbClient, BatchReportReader reportReader, MetricRepository metricRepository, ReportMetricValidator reportMetricValidator) {
        this.dbClient = dbClient;
        this.reportReader = reportReader;
        this.reportMetricValidator = reportMetricValidator;
        this.batchMeasureToMeasure = new BatchMeasureToMeasure();
        this.metricRepository = metricRepository;
    }

    @Override
    public com.google.common.base.Optional<Measure> getBaseMeasure(Component component, Metric metric) {
        Objects.requireNonNull(component);
        Objects.requireNonNull(metric);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional measureDto = this.dbClient.measureDao().selectLastMeasure(dbSession, component.getUuid(), metric.getKey());
            if (measureDto.isPresent()) {
                com.google.common.base.Optional<Measure> optional = this.measureTransformer.toMeasure((MeasureDto)measureDto.get(), metric);
                return optional;
            }
            com.google.common.base.Optional optional = com.google.common.base.Optional.absent();
            return optional;
        }
    }

    @Override
    public com.google.common.base.Optional<Measure> getRawMeasure(Component component, Metric metric) {
        com.google.common.base.Optional<Measure> local = this.delegate.getRawMeasure(component, metric);
        if (local.isPresent()) {
            return local;
        }
        this.loadBatchMeasuresForComponent(component);
        return this.delegate.getRawMeasure(component, metric);
    }

    @Override
    public void add(Component component, Metric metric, Measure measure) {
        this.delegate.add(component, metric, measure);
    }

    @Override
    public void update(Component component, Metric metric, Measure measure) {
        this.delegate.update(component, metric, measure);
    }

    @Override
    public Set<Measure> getRawMeasures(Component component, Metric metric) {
        this.loadBatchMeasuresForComponent(component);
        return this.delegate.getRawMeasures(component, metric);
    }

    @Override
    public SetMultimap<String, Measure> getRawMeasures(Component component) {
        this.loadBatchMeasuresForComponent(component);
        return this.delegate.getRawMeasures(component);
    }

    private void loadBatchMeasuresForComponent(Component component) {
        if (this.loadedComponents.contains(component.getReportAttributes().getRef())) {
            return;
        }
        try (CloseableIterator<ScannerReport.Measure> readIt = this.reportReader.readComponentMeasures(component.getReportAttributes().getRef());){
            while (readIt.hasNext()) {
                ScannerReport.Measure batchMeasure = (ScannerReport.Measure)readIt.next();
                String metricKey = batchMeasure.getMetricKey();
                if (!this.reportMetricValidator.validate(metricKey)) continue;
                Metric metric = this.metricRepository.getByKey(metricKey);
                this.delegate.add(component, metric, (Measure)this.batchMeasureToMeasure.toMeasure(batchMeasure, metric).get(), MapBasedRawMeasureRepository.OverridePolicy.DO_NOT_OVERRIDE);
            }
        }
        this.loadedComponents.add(component.getReportAttributes().getRef());
    }
}

