/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.measure;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureKey;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.Metric;

public final class MapBasedRawMeasureRepository<T>
implements MeasureRepository {
    private final Function<Component, T> componentToKey;
    private final Map<T, Map<MeasureKey, Measure>> measures = new HashMap<T, Map<MeasureKey, Measure>>();

    public MapBasedRawMeasureRepository(Function<Component, T> componentToKey) {
        this.componentToKey = Objects.requireNonNull(componentToKey);
    }

    @Override
    public Optional<Measure> getBaseMeasure(Component component, Metric metric) {
        throw new UnsupportedOperationException("This implementation of MeasureRepository supports only raw measures");
    }

    @Override
    public Optional<Measure> getRawMeasure(Component component, Metric metric) {
        Objects.requireNonNull(component);
        Objects.requireNonNull(metric);
        return this.find(component, metric);
    }

    @Override
    public void add(Component component, Metric metric, Measure measure) {
        Objects.requireNonNull(component);
        MapBasedRawMeasureRepository.checkValueTypeConsistency(metric, measure);
        Optional<Measure> existingMeasure = this.find(component, metric, measure);
        if (existingMeasure.isPresent()) {
            throw new UnsupportedOperationException(String.format("a measure can be set only once for a specific Component (key=%s), Metric (key=%s). Use update method", component.getKey(), metric.getKey()));
        }
        this.add(component, metric, measure, OverridePolicy.OVERRIDE);
    }

    @Override
    public void update(Component component, Metric metric, Measure measure) {
        Objects.requireNonNull(component);
        MapBasedRawMeasureRepository.checkValueTypeConsistency(metric, measure);
        Optional<Measure> existingMeasure = this.find(component, metric, measure);
        if (!existingMeasure.isPresent()) {
            throw new UnsupportedOperationException(String.format("a measure can be updated only if one already exists for a specific Component (key=%s), Metric (key=%s). Use add method", component.getKey(), metric.getKey()));
        }
        this.add(component, metric, measure, OverridePolicy.OVERRIDE);
    }

    private static void checkValueTypeConsistency(Metric metric, Measure measure) {
        Preconditions.checkArgument((measure.getValueType() == Measure.ValueType.NO_VALUE || measure.getValueType() == metric.getType().getValueType() ? 1 : 0) != 0, (String)"Measure's ValueType (%s) is not consistent with the Metric's ValueType (%s)", (Object[])new Object[]{measure.getValueType(), metric.getType().getValueType()});
    }

    @Override
    public Set<Measure> getRawMeasures(Component component, Metric metric) {
        Objects.requireNonNull(metric);
        Objects.requireNonNull(component);
        Object componentKey = this.componentToKey.apply((Object)component);
        Map<MeasureKey, Measure> rawMeasures = this.measures.get(componentKey);
        if (rawMeasures == null) {
            return Collections.emptySet();
        }
        return FluentIterable.from(rawMeasures.entrySet()).filter((Predicate)new MatchMetric(metric)).transform((Function)ToMeasure.INSTANCE).toSet();
    }

    @Override
    public SetMultimap<String, Measure> getRawMeasures(Component component) {
        Object componentKey = this.componentToKey.apply((Object)component);
        Map<MeasureKey, Measure> rawMeasures = this.measures.get(componentKey);
        if (rawMeasures == null) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry<MeasureKey, Measure> entry : rawMeasures.entrySet()) {
            builder.put((Object)entry.getKey().getMetricKey(), (Object)entry.getValue());
        }
        return builder.build();
    }

    private Optional<Measure> find(Component component, Metric metric) {
        Object componentKey = this.componentToKey.apply((Object)component);
        Map<MeasureKey, Measure> measuresPerMetric = this.measures.get(componentKey);
        if (measuresPerMetric == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)measuresPerMetric.get(new MeasureKey(metric.getKey(), null)));
    }

    private Optional<Measure> find(Component component, Metric metric, Measure measure) {
        Object componentKey = this.componentToKey.apply((Object)component);
        Map<MeasureKey, Measure> measuresPerMetric = this.measures.get(componentKey);
        if (measuresPerMetric == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)measuresPerMetric.get(new MeasureKey(metric.getKey(), measure.getDeveloper())));
    }

    public void add(Component component, Metric metric, Measure measure, OverridePolicy overridePolicy) {
        MeasureKey key;
        Objects.requireNonNull(component);
        Objects.requireNonNull(measure);
        Objects.requireNonNull(measure);
        Objects.requireNonNull(overridePolicy);
        Object componentKey = this.componentToKey.apply((Object)component);
        Map<MeasureKey, Measure> measuresPerMetric = this.measures.get(componentKey);
        if (measuresPerMetric == null) {
            measuresPerMetric = new HashMap<MeasureKey, Measure>();
            this.measures.put(componentKey, measuresPerMetric);
        }
        if (!measuresPerMetric.containsKey(key = new MeasureKey(metric.getKey(), measure.getDeveloper())) || overridePolicy == OverridePolicy.OVERRIDE) {
            measuresPerMetric.put(key, measure);
        }
    }

    private static enum ToMeasure implements Function<Map.Entry<MeasureKey, Measure>, Measure>
    {
        INSTANCE;


        @Nullable
        public Measure apply(@Nonnull Map.Entry<MeasureKey, Measure> input) {
            return input.getValue();
        }
    }

    private static class MatchMetric
    implements Predicate<Map.Entry<MeasureKey, Measure>> {
        private final Metric metric;

        public MatchMetric(Metric metric) {
            this.metric = metric;
        }

        public boolean apply(@Nonnull Map.Entry<MeasureKey, Measure> input) {
            return input.getKey().getMetricKey().equals(this.metric.getKey());
        }
    }

    public static enum OverridePolicy {
        OVERRIDE,
        DO_NOT_OVERRIDE;

    }
}

