/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LazyInput;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.MergeBranchComponentUuids;
import org.sonar.server.computation.task.projectanalysis.issue.ComponentIssuesLoader;

public class TrackerMergeBranchInputFactory {
    private static final LineHashSequence EMPTY_LINE_HASH_SEQUENCE = new LineHashSequence(Collections.emptyList());
    private final ComponentIssuesLoader mergeIssuesLoader;
    private final DbClient dbClient;
    private final MergeBranchComponentUuids mergeBranchComponentUuids;

    public TrackerMergeBranchInputFactory(ComponentIssuesLoader mergeIssuesLoader, MergeBranchComponentUuids mergeBranchComponentUuids, DbClient dbClient) {
        this.mergeIssuesLoader = mergeIssuesLoader;
        this.mergeBranchComponentUuids = mergeBranchComponentUuids;
        this.dbClient = dbClient;
    }

    public Input<DefaultIssue> create(Component component) {
        String mergeBranchComponentUuid = this.mergeBranchComponentUuids.getUuid(component.getKey());
        return new MergeLazyInput(component.getType(), mergeBranchComponentUuid);
    }

    private class MergeLazyInput
    extends LazyInput<DefaultIssue> {
        private final Component.Type type;
        private final String mergeBranchComponentUuid;

        private MergeLazyInput(@Nullable Component.Type type, String mergeBranchComponentUuid) {
            this.type = type;
            this.mergeBranchComponentUuid = mergeBranchComponentUuid;
        }

        protected LineHashSequence loadLineHashSequence() {
            if (this.mergeBranchComponentUuid == null || this.type != Component.Type.FILE) {
                return EMPTY_LINE_HASH_SEQUENCE;
            }
            try (DbSession session = TrackerMergeBranchInputFactory.this.dbClient.openSession(false);){
                List hashes = TrackerMergeBranchInputFactory.this.dbClient.fileSourceDao().selectLineHashes(session, this.mergeBranchComponentUuid);
                if (hashes == null || hashes.isEmpty()) {
                    LineHashSequence lineHashSequence = EMPTY_LINE_HASH_SEQUENCE;
                    return lineHashSequence;
                }
                LineHashSequence lineHashSequence = new LineHashSequence(hashes);
                return lineHashSequence;
            }
        }

        protected List<DefaultIssue> loadIssues() {
            if (this.mergeBranchComponentUuid == null) {
                return Collections.emptyList();
            }
            return TrackerMergeBranchInputFactory.this.mergeIssuesLoader.loadForComponentUuidWithChanges(this.mergeBranchComponentUuid);
        }
    }
}

