/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.DeprecatedRuleKeyDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.issue.NewExternalRule;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleImpl;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;
import org.sonar.server.rule.ExternalRuleCreator;

public class RuleRepositoryImpl
implements RuleRepository {
    @CheckForNull
    private Map<RuleKey, Rule> rulesByKey;
    @CheckForNull
    private Map<Integer, Rule> rulesById;
    private final ExternalRuleCreator creator;
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public RuleRepositoryImpl(ExternalRuleCreator creator, DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder) {
        this.creator = creator;
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void insertNewExternalRuleIfAbsent(RuleKey ruleKey, Supplier<NewExternalRule> ruleSupplier) {
        this.ensureInitialized();
        if (!this.rulesByKey.containsKey(ruleKey)) {
            this.rulesByKey.computeIfAbsent(ruleKey, s -> (NewExternalRule)ruleSupplier.get());
        }
    }

    @Override
    public void persistNewExternalRules(DbSession dbSession) {
        this.ensureInitialized();
        this.rulesByKey.values().stream().filter(NewExternalRule.class::isInstance).forEach(extRule -> this.persistAndIndex(dbSession, (NewExternalRule)extRule));
    }

    private void persistAndIndex(DbSession dbSession, NewExternalRule external) {
        Rule rule = this.creator.persistAndIndex(dbSession, external);
        this.rulesById.put(rule.getId(), rule);
        this.rulesByKey.put(external.getKey(), rule);
    }

    @Override
    public Rule getByKey(RuleKey key) {
        RuleRepositoryImpl.verifyKeyArgument(key);
        this.ensureInitialized();
        Rule rule = this.rulesByKey.get(key);
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (String)"Can not find rule for key %s. This rule does not exist in DB", (Object[])new Object[]{key});
        return rule;
    }

    @Override
    public Optional<Rule> findByKey(RuleKey key) {
        RuleRepositoryImpl.verifyKeyArgument(key);
        this.ensureInitialized();
        return Optional.ofNullable(this.rulesByKey.get(key));
    }

    @Override
    public Rule getById(int id) {
        this.ensureInitialized();
        Rule rule = this.rulesById.get(id);
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (String)"Can not find rule for id %s. This rule does not exist in DB", (Object[])new Object[]{id});
        return rule;
    }

    @Override
    public Optional<Rule> findById(int id) {
        this.ensureInitialized();
        return Optional.ofNullable(this.rulesById.get(id));
    }

    private static void verifyKeyArgument(RuleKey key) {
        Objects.requireNonNull(key, "RuleKey can not be null");
    }

    private void ensureInitialized() {
        if (this.rulesByKey == null) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                this.loadRulesFromDb(dbSession);
            }
        }
    }

    private void loadRulesFromDb(DbSession dbSession) {
        this.rulesByKey = new HashMap<RuleKey, Rule>();
        this.rulesById = new HashMap<Integer, Rule>();
        String organizationUuid = this.analysisMetadataHolder.getOrganization().getUuid();
        Multimap deprecatedRuleKeysByRuleId = (Multimap)this.dbClient.ruleDao().selectAllDeprecatedRuleKeys(dbSession).stream().collect(MoreCollectors.index(DeprecatedRuleKeyDto::getRuleId));
        for (RuleDto ruleDto : this.dbClient.ruleDao().selectAll(dbSession, organizationUuid)) {
            RuleImpl rule = new RuleImpl(ruleDto);
            this.rulesByKey.put(ruleDto.getKey(), rule);
            this.rulesById.put(ruleDto.getId(), rule);
            deprecatedRuleKeysByRuleId.get((Object)ruleDto.getId()).forEach(t -> this.rulesByKey.put(RuleKey.of((String)t.getOldRepositoryKey(), (String)t.getOldRuleKey()), rule));
        }
    }
}

