/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Strings;
import java.util.Date;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.DefaultAssignee;
import org.sonar.server.computation.task.projectanalysis.issue.IssueVisitor;
import org.sonar.server.computation.task.projectanalysis.issue.ScmAccountToUser;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.server.issue.IssueFieldsSetter;

public class IssueAssigner
extends IssueVisitor {
    private static final Logger LOGGER = Loggers.get(IssueAssigner.class);
    private final ScmInfoRepository scmInfoRepository;
    private final DefaultAssignee defaultAssignee;
    private final IssueFieldsSetter issueUpdater;
    private final ScmAccountToUser scmAccountToUser;
    private final IssueChangeContext changeContext;
    private String lastCommitAuthor = null;
    private ScmInfo scmChangesets = null;

    public IssueAssigner(AnalysisMetadataHolder analysisMetadataHolder, ScmInfoRepository scmInfoRepository, ScmAccountToUser scmAccountToUser, DefaultAssignee defaultAssignee, IssueFieldsSetter issueUpdater) {
        this.scmInfoRepository = scmInfoRepository;
        this.scmAccountToUser = scmAccountToUser;
        this.defaultAssignee = defaultAssignee;
        this.issueUpdater = issueUpdater;
        this.changeContext = IssueChangeContext.createScan((Date)new Date(analysisMetadataHolder.getAnalysisDate()));
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (issue.authorLogin() == null) {
            this.loadScmChangesets(component);
            String scmAuthor = this.guessScmAuthor(issue);
            if (!Strings.isNullOrEmpty((String)scmAuthor)) {
                if (scmAuthor.length() <= 255) {
                    this.issueUpdater.setNewAuthor(issue, scmAuthor, this.changeContext);
                } else {
                    LOGGER.debug("SCM account '{}' is too long to be stored as issue author", (Object)scmAuthor);
                }
            }
            if (issue.assignee() == null) {
                String assigneeUuid = Strings.isNullOrEmpty((String)scmAuthor) ? null : (String)this.scmAccountToUser.getNullable(scmAuthor);
                assigneeUuid = StringUtils.defaultIfEmpty((String)assigneeUuid, (String)this.defaultAssignee.loadDefaultAssigneeUuid());
                this.issueUpdater.setNewAssignee(issue, assigneeUuid, this.changeContext);
            }
        }
    }

    private void loadScmChangesets(Component component) {
        Optional<ScmInfo> scmInfoOptional;
        if (this.scmChangesets == null && (scmInfoOptional = this.scmInfoRepository.getScmInfo(component)).isPresent()) {
            this.scmChangesets = scmInfoOptional.get();
            this.lastCommitAuthor = this.scmChangesets.getLatestChangeset().getAuthor();
        }
    }

    @Override
    public void afterComponent(Component component) {
        this.lastCommitAuthor = null;
        this.scmChangesets = null;
    }

    @CheckForNull
    private String guessScmAuthor(DefaultIssue issue) {
        Integer line = issue.line();
        String author = null;
        if (line != null && this.scmChangesets != null) {
            if (this.scmChangesets.hasChangesetForLine(line)) {
                author = this.scmChangesets.getChangesetForLine(line).getAuthor();
            } else {
                LOGGER.warn("No SCM info has been found for issue {}", (Object)issue);
            }
        }
        return StringUtils.defaultIfEmpty(author, (String)this.lastCommitAuthor);
    }
}

