/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.ConfigurationRepository;

public class DefaultAssignee {
    private static final Logger LOG = Loggers.get(DefaultAssignee.class);
    private final DbClient dbClient;
    private final ConfigurationRepository configRepository;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private boolean loaded = false;
    private String userUuid = null;

    public DefaultAssignee(DbClient dbClient, ConfigurationRepository configRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.configRepository = configRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @CheckForNull
    public String loadDefaultAssigneeUuid() {
        if (this.loaded) {
            return this.userUuid;
        }
        String login = this.configRepository.getConfiguration().get("sonar.issues.defaultAssigneeLogin").orElse(null);
        if (!Strings.isNullOrEmpty((String)login)) {
            this.userUuid = this.findValidUserUuidFromLogin(login);
        }
        this.loaded = true;
        return this.userUuid;
    }

    private String findValidUserUuidFromLogin(String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
            if (user == null) {
                LOG.info("Property {} is set with an unknown login: {}", (Object)"sonar.issues.defaultAssigneeLogin", (Object)login);
                String string = null;
                return string;
            }
            if (!this.isUserMemberOfOrganization(dbSession, user)) {
                LOG.info("Property {} is set with a user which is not member of the organization of the project : {}", (Object)"sonar.issues.defaultAssigneeLogin", (Object)login);
                String string = null;
                return string;
            }
            String string = user.getUuid();
            return string;
        }
    }

    private boolean isUserMemberOfOrganization(DbSession dbSession, UserDto user) {
        return this.dbClient.organizationMemberDao().select(dbSession, this.analysisMetadataHolder.getOrganization().getUuid(), user.getId().intValue()).isPresent();
    }
}

